## Localization

The **Localization** settings allow you to set global defaults for your Metabase instance. Localization settings include options for:

- **Language**
- **Date and time**
- **Numbers**
- **Currency**

The **Localization** settings can be found in the **Admin Panel** under the **Settings** tab.

### Instance language

The default language for all users across the Metabase UI, system emails, pulses, and alerts. Users can pick a different language from their own account settings page.

See a [list of languages Metabase supports](https://www.metabase.com/docs/latest/faq/general/what-languages-can-be-used-with-metabase.html).

### First day of the week

If you need to, you can change the first day of the week for your instance (the default is Sunday). Setting the first day of the week affects things like grouping by week and filtering in GUI queries ([simple](../users-guide/04-asking-questions.html) and [custom questions](../users-guide/custom-questions.html) composed in the notebook editor). This setting does not affect [SQL queries](../users-guide/writing-sql.html).

### Localization options

**Dates and Times**

- `Date style:` the way dates should be displayed in tables, axis labels, and tooltips.
- `Date separators:` you can choose between slashes, dashes, and dots here.
- `Abbreviate names of days and months:` whenever a date is displayed with the day of the week and/or the month written out, turning this setting on will display e.g. `January` as `Jan` or `Monday` as `Mon`.
- `Time style:` this lets you choose between a 12-hour or 24-hour clock to display the time by default where applicable.

**Numbers**

- `Separator style:` some folks use commas to separate thousands places, and others use periods. Here's where you can indicate which camp you belong to.

**Currency**

- `Unit of currency:` if you do most of your business in a particular currency, you can specify that here.
- `Currency label style:` whether you want to have your currencies labeled with a symbol, a code (like `USD`), or its full name.
- `Where to display the unit of currency:` this pertains specifically to tables, and lets you choose if you want the currency labels to appear only in the column heading, or next to each value in the column.
