/* @flow weak */
/* eslint-disable no-color-literals */

/*
    Metabase Icon Paths
    -----

    These paths represent the current canonical icon set for Metabase.
*/

export const ICON_PATHS = {
  add:
    "M12.4285714,12.4285714 L12.4285714,0 L19.5714286,0 L19.5714286,12.4285714 L32,12.4285714 L32,19.5714286 L19.5714286,19.5714286 L19.5714286,32 L12.4285714,32 L12.4285714,19.5714286 L0,19.5714286 L0,12.4285714 L12.4285714,12.4285714 Z",
  add_data:
    "M0 8h5.926v6.208H0V8zm7.704 0h5.926v6.208H7.704V8zM0 16.07h5.926v6.209H0V16.07zm7.704 0h5.926v6.209H7.704V16.07zm7.703 0h5.926v6.209h-5.926V16.07zM0 24.142h5.926v6.208H0v-6.208zm7.704 0h5.926v6.208H7.704v-6.208zm7.703 0h5.926v6.208h-5.926v-6.208zM23.08 8.08V3h4.064v5.08h5.08v4.063h-5.08v5.08h-4.064v-5.08H18V8.079h5.08z",
  add_to_dash: {
    path:
      "M21,23 L16,23 L16,27 L21,27 L21,32 L25,32 L25,27 L30,27 L30,23 L25,23 L25,18 L21,18 L21,23 Z M32,7 L32,14 L28,14 L28,8 L0,8 L0,4 L0,4 C-2.705415e-16,1.790861 1.790861,4.05812251e-16 4,0 L4,0 L28,0 C30.209139,-4.05812251e-16 32,1.790861 32,4 L32,7 Z M0,8 L4,8 L4,28 L0,28 L0,8 Z M0,28 L12,28 L12,32 L4,32 C1.790861,32 2.705415e-16,30.209139 0,28 Z",
    attrs: { fillRule: "evenodd" },
  },
  alert: {
    path:
      "M14.677 7.339c-4.77.562-5.23 4.75-5.23 7.149 0 2.576 0 3.606-.53 4.121-.352.344-1.058.515-2.117.515V21.7h18v-2.576c-1.059 0-1.588 0-2.118-.515-.353-.343-.53-2.06-.53-5.151-.316-3.705-2.06-5.745-5.23-6.12a1.52 1.52 0 0 0 .466-1.093c0-.853-.71-1.545-1.588-1.545-.877 0-1.588.692-1.588 1.545 0 .427.178.814.465 1.094zM16.05 0c2.473 0 5.57 1.851 6.22 4.12 3.057 1.58 4.868 4.503 5.223 8.706l.013.158v.157c0 .905.014 1.682.042 2.327H30.6V25.73H1.5V15.468h3.091c.002-.326.003-.725.003-1.222 0-2.308.316-4.322 1.26-6.233.881-1.784 2.223-2.988 3.976-3.893C10.48 1.85 13.576 0 16.05 0zM13.1 25.8c.25 1.6 1.166 2.4 2.75 2.4s2.5-.8 2.75-2.4h-5.5zm-4.35-3.16h14.191l-.586 3.261c-.497 3.607-2.919 6.001-6.51 6.001-3.59 0-6.012-2.394-6.508-6L8.75 22.64z",
    attrs: { fillRule: "nonzero" },
  },
  alert_confirm: {
    path:
      "M24.326 7.184a9.604 9.604 0 0 0-.021-.034c-.876-1.39-2.056-2.47-3.518-3.19-.509-2.269-2.51-3.96-4.9-3.96-2.361 0-4.344 1.652-4.881 3.88C7.113 5.63 5.68 9.55 5.68 14.424c0 .88-.003 1.473-.01 1.902H2.8v9.605h26.175v-9.602h-3.297v6.257H6.097V19.67c1.152 0 1.92-.194 2.304-.583.576-.583.576-1.75.576-4.664 0-2.716.5-7.456 5.69-8.091a1.754 1.754 0 0 1-.507-1.238c0-.966.773-1.749 1.727-1.749.955 0 1.728.783 1.728 1.75 0 .483-.194.92-.507 1.237 2.2.27 3.768 1.308 4.705 3.112.037-.04.874-.793 2.513-2.26zm-11.312 18.7H9.741C10.214 29.398 12.48 32 15.887 32c3.409 0 5.674-2.602 6.147-6.116H18.76c-.27 1.911-1.228 2.77-2.874 2.77-1.645 0-2.603-.859-2.873-2.77zm.297-12.466l2.504-2.707 3.819 4.106 7.653-8.254L29.8 9.38 19.636 20.295l-6.325-6.877z",
    attrs: { fillRule: "nonzero" },
  },
  all:
    "M30.595 13.536c1.85.755 1.879 2.05.053 2.9l-11.377 5.287c-1.82.846-4.763.858-6.583.022L1.344 16.532c-1.815-.835-1.785-2.131.05-2.89l1.637-.677 8.977 4.125c2.194 1.009 5.74.994 7.934-.026l9.022-4.193 1.63.665zm-1.63 7.684l1.63.666c1.85.755 1.879 2.05.053 2.898l-11.377 5.288c-1.82.847-4.763.859-6.583.022L1.344 24.881c-1.815-.834-1.785-2.131.05-2.89l1.637-.677 8.977 4.126c2.194 1.008 5.74.993 7.934-.026l9.022-4.194zM12.686 1.576c1.843-.762 4.834-.77 6.687-.013l11.22 4.578c1.85.755 1.88 2.05.054 2.899l-11.377 5.288c-1.82.846-4.763.858-6.583.022L1.344 9.136c-1.815-.834-1.785-2.13.05-2.89l11.293-4.67z",
  archive: {
    path:
      "M27.557 1v2.356a1 1 0 0 1-1 1H5.443a1 1 0 0 1-1-1V1a1 1 0 0 1 1-1h21.114a1 1 0 0 1 1 1zM4.356 26.644h23.288v-15.57H4.356v15.57zM32 8.718V29a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V8.718a2 2 0 0 1 2-2h28a2 2 0 0 1 2 2zM16.116 25.076l5.974-6.57h-3.983V12.93h-3.982v5.575h-3.982l5.973 6.571z",
    attrs: { fillRule: "evenodd" },
  },
  area:
    "M31.154 28.846l.852.004V8.64l-1.15 2.138-6.818 6.37c-.13.122-9.148 1.622-9.148 1.622l-.545.096-.383.4-7.93 8.31-1.016 1.146 2.227.017 23.91.107L7.25 28.74l7.93-8.31 9.615-1.684 7.211-6.737v15.984a.855.855 0 0 1-.852.854zM0 28.74l11.79-13.362 11.788-3.369 8.077-8.07c.194-.193.351-.128.351.15V28.85L0 28.74z",
  attachment: {
    path:
      "M22.162 8.704c.029 8.782-.038 14.123-.194 15.926-.184 2.114-2.922 4.322-5.9 4.322-3.06 0-5.542-1.98-5.836-4.376-.294-2.392-.195-14.266.01-18.699.077-1.661 1.422-2.83 3.548-2.83 2.067 0 3.488 1.335 3.594 3.164.06 1.052.074 3.49.053 7.107-.006.928-.013 1.891-.023 3.072l-.023 2.527c-.006.824-.01 1.358-.01 1.718 0 1.547-.39 2.011-1.475 2.011-.804 0-1.202-.522-1.202-1.38V8.699a1.524 1.524 0 0 0-3.048 0v12.567c0 2.389 1.554 4.428 4.25 4.428 2.897 0 4.523-1.934 4.523-5.06 0-.348.003-.875.01-1.691l.022-2.526c.01-1.184.018-2.15.024-3.082.021-3.697.008-6.155-.058-7.3C20.227 2.592 17.469 0 13.79 0c-3.695 0-6.438 2.382-6.593 5.737-.213 4.613-.312 16.585.01 19.21C7.697 28.94 11.53 32 16.067 32c4.482 0 8.61-3.327 8.937-7.106.168-1.935.235-7.302.206-16.2a1.524 1.524 0 0 0-3.048.01z",
    attrs: { fillRule: "nonzero" },
  },
  arrow_up: {
    path:
      "M16 34.23a2.5 2.5 0 002.5-2.5V9.036l8.732 8.732a2.5 2.5 0 003.405.122l.13-.122a2.5 2.5 0 000-3.536l-13-13a2.5 2.5 0 00-3.535 0l-13 13a2.5 2.5 0 103.536 3.536L13.5 9.036V31.73a2.5 2.5 0 002.336 2.495z",
    attrs: { viewBox: "0 0 32 34" },
  },
  arrow_down: {
    path:
      "M16 .5A2.5 2.5 0 0118.5 3v22.694l8.732-8.732a2.5 2.5 0 013.405-.122l.13.122a2.5 2.5 0 010 3.536l-13 13a2.5 2.5 0 01-3.535 0l-13-13a2.5 2.5 0 113.536-3.536l8.732 8.732V3A2.5 2.5 0 0115.836.505z",
    attrs: { viewBox: "0 0 32 34" },
  },
  arrow_left: {
    path:
      "M14.502 1.232a2.5 2.5 0 113.536 3.536l-8.732 8.731L32 13.5a2.5 2.5 0 012.495 2.336L34.5 16a2.5 2.5 0 01-2.5 2.5l-22.696-.001 8.734 8.733a2.5 2.5 0 01.122 3.405l-.122.13a2.5 2.5 0 01-3.536 0l-13-13a2.5 2.5 0 010-3.535z",
    attrs: { viewBox: "0 0 35 32" },
  },
  arrow_left_to_line: {
    path: "M1,1v10 M3,6h8 M6,3L3,6L6,9",
    attrs: {
      viewBox: "0 0 12 12",
      style: {
        fill: "none",
        strokeLinecap: "round",
        strokeLinejoin: "round",
        strokeWidth: 1.5,
        stroke: "currentColor",
      },
    },
  },
  bar:
    "M2 23.467h6.4V32H2v-8.533zm10.667-12.8h6.4V32h-6.4V10.667zM23.333 0h6.4v32h-6.4V0z",
  beaker:
    "M4.31736354,31.1631075 C3.93810558,30.6054137 3.89343681,29.6635358 4.20559962,29.0817181 L11.806982,14.9140486 L11.8069821,10.5816524 L10.7015144,10.4653256 C10.0309495,10.394763 9.48734928,9.78799739 9.48734928,9.12166999 L9.48734928,7.34972895 C9.48734928,6.67821106 10.0368737,6.13383825 10.7172248,6.13383825 L21.8462005,6.13383825 C22.525442,6.13383825 23.0760761,6.68340155 23.0760761,7.34972895 L23.0760761,9.12166999 C23.0760761,9.79318788 22.5250158,10.3375607 21.856025,10.3375607 L20.9787023,10.3375607 L20.9787024,14.9281806 L28.77277,29.0827118 C29.0983515,29.6739888 29.0709073,30.6193105 28.7174156,31.1846409 L28.852457,30.9686726 C28.4963041,31.538259 27.6541076,32 26.9865771,32 L6.10749779,32 C5.43315365,32 4.58248747,31.5529687 4.19978245,30.9902061 L4.31736354,31.1631075 Z M15.5771418,17.6040443 C16.5170398,17.6040443 17.2789777,16.8377777 17.2789777,15.89254 C17.2789777,14.9473023 16.5170398,14.1810358 15.5771418,14.1810358 C14.6372438,14.1810358 13.8753059,14.9473023 13.8753059,15.89254 C13.8753059,16.8377777 14.6372438,17.6040443 15.5771418,17.6040443 Z M16.5496195,12.8974079 C17.8587633,12.8974079 18.9200339,11.830108 18.9200339,10.5135268 C18.9200339,9.1969457 17.8587633,8.1296458 16.5496195,8.1296458 C15.2404758,8.1296458 14.1792052,9.1969457 14.1792052,10.5135268 C14.1792052,11.830108 15.2404758,12.8974079 16.5496195,12.8974079 Z M5.71098553,30.2209651 L10.9595331,20.5151267 C10.9595331,20.5151267 12.6834557,21.2672852 14.3734184,21.2672852 C16.0633811,21.2672852 16.8198616,19.2872624 17.588452,18.6901539 C18.3570425,18.0930453 19.9467191,17.1113296 19.9467191,17.1113296 L27.0506095,30.1110325 L5.71098553,30.2209651 Z M13.6608671,4.37817079 C14.4114211,4.37817079 15.0198654,3.78121712 15.0198654,3.04483745 C15.0198654,2.30845779 14.4114211,1.71150412 13.6608671,1.71150412 C12.9103132,1.71150412 12.3018689,2.30845779 12.3018689,3.04483745 C12.3018689,3.78121712 12.9103132,4.37817079 13.6608671,4.37817079 Z M17.9214578,2.45333328 C18.6119674,2.45333328 19.1717361,1.90413592 19.1717361,1.22666664 C19.1717361,0.549197362 18.6119674,0 17.9214578,0 C17.2309481,0 16.6711794,0.549197362 16.6711794,1.22666664 C16.6711794,1.90413592 17.2309481,2.45333328 17.9214578,2.45333328 Z",
  bell:
    "M14.254 5.105c-7.422.874-8.136 7.388-8.136 11.12 0 4.007 0 5.61-.824 6.411-.549.535-1.647.802-3.294.802v4.006h28v-4.006c-1.647 0-2.47 0-3.294-.802-.55-.534-.824-3.205-.824-8.013-.493-5.763-3.205-8.936-8.136-9.518a2.365 2.365 0 0 0 .725-1.701C18.47 2.076 17.364 1 16 1s-2.47 1.076-2.47 2.404c0 .664.276 1.266.724 1.7zM11.849 29c.383 1.556 1.793 2.333 4.229 2.333s3.845-.777 4.229-2.333h-8.458z",
  bolt: "M21.697 0L8 16.809l7.549 2.538L11.687 32l12.652-16.6-7.695-2.317z",
  breakout:
    "M24.47 1H32v7.53h-7.53V1zm0 11.294H32v7.53h-7.53v-7.53zm0 11.294H32v7.53h-7.53v-7.53zM0 1h9.412v30.118H0V1zm11.731 13.714c.166-.183.452-.177.452-.177h6.475s-1.601-2.053-2.07-2.806c-.469-.753-.604-1.368 0-1.905.603-.536 1.226-.281 1.878.497.652.779 2.772 3.485 3.355 4.214.583.73.65 1.965 0 2.835-.65.87-2.65 4.043-3.163 4.65-.514.607-1.123.713-1.732.295-.609-.419-.838-1.187-.338-1.872.5-.684 2.07-3.073 2.07-3.073h-6.475s-.27 0-.46-.312-.151-.612-.151-.612l.007-1.246s-.014-.306.152-.488z",
  bubble:
    "M18.155 20.882c-5.178-.638-9.187-5.051-9.187-10.402C8.968 4.692 13.66 0 19.448 0c5.789 0 10.48 4.692 10.48 10.48 0 3.05-1.302 5.797-3.383 7.712a7.127 7.127 0 1 1-8.39 2.69zm-6.392 10.14a2.795 2.795 0 1 1 0-5.59 2.795 2.795 0 0 1 0 5.59zm-6.079-6.288a4.541 4.541 0 1 1 0-9.083 4.541 4.541 0 0 1 0 9.083z",
  burger:
    "M2.5 3.6h27a2.5 2.5 0 1 1 0 5h-27a2.5 2.5 0 0 1 0-5zm0 9.931h27a2.5 2.5 0 1 1 0 5h-27a2.5 2.5 0 1 1 0-5zm0 9.931h27a2.5 2.5 0 1 1 0 5h-27a2.5 2.5 0 0 1 0-5z",
  calendar: {
    path:
      "M21,2 L21,0 L18,0 L18,2 L6,2 L6,0 L3,0 L3,2 L2.99109042,2 C1.34177063,2 0,3.34314575 0,5 L0,6.99502651 L0,20.009947 C0,22.2157067 1.78640758,24 3.99005301,24 L20.009947,24 C22.2157067,24 24,22.2135924 24,20.009947 L24,6.99502651 L24,5 C24,3.34651712 22.6608432,2 21.0089096,2 L21,2 L21,2 Z M22,8 L22,20.009947 C22,21.1099173 21.1102431,22 20.009947,22 L3.99005301,22 C2.89008272,22 2,21.1102431 2,20.009947 L2,8 L22,8 L22,8 Z M6,12 L10,12 L10,16 L6,16 L6,12 Z",
    attrs: { viewBox: "0 0 24 24" },
  },
  check: "M1 14 L5 10 L13 18 L27 4 L31 8 L13 26 z ",
  chevrondown: "M1 12 L16 26 L31 12 L27 8 L16 18 L5 8 z ",
  chevronleft: "M20 1 L24 5 L14 16 L24 27 L20 31 L6 16 z",
  chevronright: "M12 1 L26 16 L12 31 L8 27 L18 16 L8 5 z ",
  chevronup: "M1 20 L16 6 L31 20 L27 24 L16 14 L5 24 z",
  click:
    "M5.38519 1C2.41104 1 0 3.41103 0 6.38519V26.779C0 29.7532 2.41103 32.1642 5.38519 32.1642H13.3818V27.7911H5.38519C4.82624 27.7911 4.37313 27.338 4.37313 26.779V6.38519C4.37313 5.82624 4.82624 5.37313 5.38519 5.37313H22.779C23.338 5.37313 23.7911 5.82624 23.7911 6.38519V7.98451H28.1642V6.38519C28.1642 3.41103 25.7532 1 22.779 1H5.38519ZM12 10.6L17.5213 29.1906L21.8777 24.8341L27.6436 30.6L32 26.2436L26.2341 20.4777L30.5906 16.1213L12 10.6Z",
  clipboard:
    "M8.54667751,5.50894675 L6.00494659,5.50894675 C4.89702623,5.50894675 4,6.40070914 4,7.50075379 L4,30.0171397 C4,31.1120596 4.89764516,32.0089468 6.00494659,32.0089468 L25.9950534,32.0089468 C27.1029738,32.0089468 28,31.1171844 28,30.0171397 L28,7.50075379 C28,6.40583387 27.1023548,5.50894675 25.9950534,5.50894675 L23.5373296,5.50894675 L23.5373296,3.0446713 L19.9106557,3.0446713 C19.9106557,3.0446713 19.6485834,8.05825522e-08 16.0837607,0 C12.518938,-8.05825523e-08 12.1644547,3.04776207 12.1644547,3.04776207 L8.57253264,3.04776207 L8.54667751,5.50894675 Z M23.5373296,7.50894675 L26,7.50894675 L26,30.0089468 L6,30.0089468 L6,7.50894675 L8.52566721,7.50894675 L8.4996301,9.98745456 L23.5373296,9.98745456 L23.5373296,7.50894675 Z M10.573037,5.01478303 L13.9861608,5.01478303 L13.9861608,3.76128231 C13.9861608,3.76128231 14.0254332,1.94834752 16.0135743,1.94834752 C18.0017155,1.94834752 18.0017156,3.7055821 18.0017156,3.7055821 L18.0017156,4.94060459 L21.4955568,4.94060459 L21.4955568,8.03924122 L10.5173901,8.03924122 L10.573037,5.01478303 Z M16,5.00894675 C16.5522847,5.00894675 17,4.5612315 17,4.00894675 C17,3.456662 16.5522847,3.00894675 16,3.00894675 C15.4477153,3.00894675 15,3.456662 15,4.00894675 C15,4.5612315 15.4477153,5.00894675 16,5.00894675 Z M8.5,18.0089468 L8.5,21.0082323 L11.5,21.0082323 L11.5,18.0446111 L8.5,18.0089468 Z M8.5,23.0089468 L8.5,26.0082323 L11.5,26.0082323 L11.5,23.0446111 L8.5,23.0089468 Z M8.5,13.0089468 L8.5,16.0082323 L11.5,16.0082323 L11.5,13.0446111 L8.5,13.0089468 Z M13.5,13.0193041 L13.5,16 L23.5,16 L23.5,13 L13.5,13.0193041 Z M13.5,23.0193041 L13.5,26 L23.5,26 L23.5,23 L13.5,23.0193041 Z M13.5,18.0193041 L13.5,21 L23.5,21 L23.5,18 L13.5,18.0193041 Z",
  clock:
    "M16 0 A16 16 0 0 0 0 16 A16 16 0 0 0 16 32 A16 16 0 0 0 32 16 A16 16 0 0 0 16 0 M16 4 A12 12 0 0 1 28 16 A12 12 0 0 1 16 28 A12 12 0 0 1 4 16 A12 12 0 0 1 16 4 M14 6 L14 17.25 L22 22 L24.25 18.5 L18 14.75 L18 6z",
  clone: {
    path:
      "M24,22 L32,22 L32,0 L10,0 L10,6 L24,6 L24,22 L24,22 Z M0,8 L22,8 L22,30 L0,30 L0,8 Z",
    attrs: { viewBox: "0 0 32 30" },
  },
  close:
    "M4 8 L8 4 L16 12 L24 4 L28 8 L20 16 L28 24 L24 28 L16 20 L8 28 L4 24 L12 16 z ",
  cloud:
    "M6.951 12.397a7.385 7.385 0 0 0 .434 14.757h17.23a7.385 7.385 0 0 0 .434-14.757C24.199 8.177 20.47 5 16 5s-8.198 3.178-9.049 7.397z",
  collection:
    "M16.5695046,2.82779686 L15.5639388,2.83217072 L30.4703127,11.5065092 L30.4818076,9.80229623 L15.5754337,18.2115855 L16.5436335,18.2077098 L1.65289961,9.96407638 L1.67877073,11.6677911 L16.5695046,2.82779686 Z M0.691634577,11.6826271 L15.5823685,19.9262606 C15.8836872,20.0930731 16.2506087,20.0916044 16.5505684,19.9223849 L31.4569423,11.5130957 C32.1196316,11.1392458 32.1260238,10.1915465 31.4684372,9.80888276 L16.5620632,1.1345443 C16.2511162,0.953597567 15.8658421,0.955273376 15.5564974,1.13891816 L0.665763463,9.97891239 C0.0118284022,10.3671258 0.0262104889,11.3142428 0.691634577,11.6826271 Z M15.5699489,25.798061 L16.0547338,26.0652615 L16.536759,25.7931643 L31.4991818,17.3470627 C31.973977,17.0790467 32.1404815,16.4788587 31.8710802,16.0065052 C31.6016788,15.5341517 30.9983884,15.3685033 30.5235933,15.6365193 L15.5611705,24.0826209 L16.5279806,24.0777242 L1.46763754,15.7768642 C0.99012406,15.5136715 0.388560187,15.6854222 0.124007019,16.16048 C-0.14054615,16.6355379 0.0320922897,17.2340083 0.509605765,17.497201 L15.5699489,25.798061 Z M15.5699489,31.7327994 L16.0547338,32 L16.536759,31.7279028 L31.4991818,23.2818011 C31.973977,23.0137852 32.1404815,22.4135972 31.8710802,21.9412437 C31.6016788,21.4688901 30.9983884,21.3032418 30.5235933,21.5712578 L15.5611705,30.0173594 L16.5279806,30.0124627 L1.46763754,21.7116027 C0.99012406,21.44841 0.388560187,21.6201606 0.124007019,22.0952185 C-0.14054615,22.5702764 0.0320922897,23.1687467 0.509605765,23.4319394 L15.5699489,31.7327994 Z",
  compare:
    "M24.5815137,18.6109617 L32.110976,18.6109617 L32.110976,25.7224662 L24.5815137,25.7224662 L24.5815137,31.7951059 L14.9536477,22.1672398 L24.5815137,12.5393738 L24.5815137,18.6109617 Z M7.52979828,20.2568769 L7.52941566,14.1855356 L0.000277209616,14.1851279 L-3.37507799e-14,7.07317197 L7.52913845,7.0735796 L7.5287557,1 L17.1577154,10.6289597 L7.52979828,20.2568769 Z",
  connections: {
    path:
      "M5.37815706,11.5570815 C5.55061975,11.1918363 5.64705882,10.783651 5.64705882,10.3529412 C5.64705882,9.93118218 5.55458641,9.53102128 5.38881053,9.1716274 L11.1846365,4.82475792 C11.6952189,5.33295842 12.3991637,5.64705882 13.1764706,5.64705882 C14.7358628,5.64705882 16,4.38292165 16,2.82352941 C16,1.26413718 14.7358628,0 13.1764706,0 C11.6170784,0 10.3529412,1.26413718 10.3529412,2.82352941 C10.3529412,3.2452884 10.4454136,3.64544931 10.6111895,4.00484319 L10.6111895,4.00484319 L4.81536351,8.35171266 C4.3047811,7.84351217 3.60083629,7.52941176 2.82352941,7.52941176 C1.26413718,7.52941176 0,8.79354894 0,10.3529412 C0,11.9123334 1.26413718,13.1764706 2.82352941,13.1764706 C3.59147157,13.1764706 4.28780867,12.8698929 4.79682555,12.3724528 L10.510616,16.0085013 C10.408473,16.3004758 10.3529412,16.6143411 10.3529412,16.9411765 C10.3529412,18.5005687 11.6170784,19.7647059 13.1764706,19.7647059 C14.7358628,19.7647059 16,18.5005687 16,16.9411765 C16,15.3817842 14.7358628,14.1176471 13.1764706,14.1176471 C12.3029783,14.1176471 11.5221273,14.5142917 11.0042049,15.1372938 L5.37815706,11.5570815 Z",
    attrs: { viewBox: "0 0 16 19.7647" },
  },
  contract:
    "M18.0015892,0.327942852 L18.0015892,14 L31.6736463,14 L26.6544389,8.98079262 L32,3.63523156 L28.3647684,0 L23.0192074,5.34556106 L18.0015892,0.327942852 Z M14,31.6720571 L14,18 L0.327942852,18 L5.34715023,23.0192074 L0.00158917013,28.3647684 L3.63682073,32 L8.98238179,26.6544389 L14,31.6720571 Z",
  copy: {
    path:
      "M10.329 6.4h-3.33c-.95 0-1.72.77-1.72 1.72v.413h17.118V8.12c0-.941-.77-1.719-1.72-1.719h-3.31l-1.432-1.705a2.137 2.137 0 0 0-2.097-2.562 2.137 2.137 0 0 0-2.054 2.73L10.329 6.4zm12.808 4.267h1.4v8.557h-4.42l.111-4.188-5.981 6.064 5.805 6.264v-3.966h4.485v6.469H3.14v-19.2h19.997zm3.54 12.731v6.888c0 .947-.769 1.714-1.725 1.714H2.725C1.772 32 1 31.23 1 30.286V5.981c0-.947.768-1.714 1.725-1.714h6.834A4.273 4.273 0 0 1 13.839 0c2.363 0 4.279 1.91 4.279 4.267h6.834c.953 0 1.725.77 1.725 1.714v13.243H31v4.174h-4.323zM5.279 12.8h10.7v2.133h-10.7V12.8zm0 4.267h5.564V19.2H5.279v-2.133zm0 4.266h5.564v2.134H5.279v-2.134zm0 4.267h8.56v2.133h-8.56V25.6z",
    attrs: { fillRule: "evenodd" },
  },
  curved:
    "M3.314 25.007c-.398.852-1.427 1.228-2.298.84a1.68 1.68 0 0 1-.86-2.247c3.754-8.047 7.654-12.229 12.06-12.229 2.93 0 4.406 1.185 6.481 4.098l.098.137c1.413 1.984 2.054 2.507 3.318 2.507 2.293 0 4.562-2.814 6.495-8.918.283-.895 1.254-1.396 2.17-1.119.915.277 1.427 1.227 1.144 2.122-2.337 7.38-5.503 11.307-9.809 11.307-2.765 0-4.15-1.132-6.166-3.961l-.097-.137c-1.479-2.075-2.187-2.644-3.635-2.644-2.58 0-5.667 3.31-8.901 10.244z",
  csv:
    "M28 10.105v18.728A3.166 3.166 0 0 1 24.834 32H6.166A3.163 3.163 0 0 1 3 28.844V3.156A3.163 3.163 0 0 1 6.16 0h13.553V10.105H28zm-.215-1.684h-6.4V.311l6.4 8.11zM17 13v2h2v-2h-2zm0 4v2h2v-2h-2zm4-4v2h2v-2h-2zM7 13v2h7v-2H7zm14 4v2h2v-2h-2zM7 17v2h7v-2H7zm10 4v2h2v-2h-2zm4 0v2h2v-2h-2zM7 21v2h7v-2H7z",
  database:
    "M0 9.32V4.054S1.584 0 15.657 0C29.731 0 31.89 3.669 31.89 4.054v5.24s-1.445 4.125-15.424 4.125S0 10.138 0 9.32zm.305 12.93s2.044 3.692 15.727 3.692 15.63-3.72 15.63-3.72.338.099.338.632v5S30.463 32 15.964 32C1.465 32 .041 27.817.041 27.817V22.9c0-.582.264-.65.264-.65zm0-9.368s2.044 3.692 15.727 3.692 15.63-3.72 15.63-3.72.338.099.338.632v5.001s-1.537 4.145-16.036 4.145C1.465 22.632.041 18.45.041 18.45v-4.918c0-.583.264-.65.264-.65z",
  dash: "M0 13h32v6.61H0z",
  dashboard:
    "M32 28a4 4 0 0 1-4 4H4a4.002 4.002 0 0 1-3.874-3H0V4a4 4 0 0 1 4-4h25a3 3 0 0 1 3 3v25zm-4 0V8H4v20h24zM7.273 18.91h10.182v4.363H7.273v-4.364zm0-6.82h17.454v4.365H7.273V12.09zm13.09 6.82h4.364v4.363h-4.363v-4.364z",
  curve:
    "M3.033 3.791v22.211H31.09c.403 0 .882.872.882 1.59 0 .717-.48 1.408-.882 1.408H0V3.791c0-.403.875-.914 1.487-.914.612 0 1.546.511 1.546.914zm3.804 17.912C5.714 21.495 5 20.318 5 19.355c0-.963.831-2.296 1.837-2.296 2.093 0 2.965-1.207 4.204-5.242l.148-.482C12.798 6.077 14.18 3 17.968 3c3.792 0 5.17 3.08 6.765 8.343l.145.478c1.227 4.034 2.093 5.238 4.181 5.238 1.006 0 1.875 1.29 1.875 2.296 0 1.007-.898 2.184-1.875 2.348-3.656.612-6.004-2.364-7.665-7.821l-.146-.482c-1.14-3.76-1.8-6.754-3.28-6.754-1.483 0-2.147 2.995-3.297 6.754l-.148.486c-1.675 5.454-3.93 8.514-7.686 7.817z",
  document:
    "M29,10.1052632 L29,28.8325291 C29,30.581875 27.5842615,32 25.8337327,32 L7.16626728,32 C5.41758615,32 4,30.5837102 4,28.8441405 L4,3.15585953 C4,1.41292644 5.42339685,9.39605581e-15 7.15970573,8.42009882e-15 L20.713352,8.01767853e-16 L20.713352,8.42105263 L22.3846872,8.42105263 L22.3846872,0.310375032 L28.7849894,8.42105263 L20.713352,8.42105263 L20.713352,10.1052632 L29,10.1052632 Z M7.3426704,12.8000006 L25.7273576,12.8000006 L25.7273576,14.4842112 L7.3426704,14.4842112 L7.3426704,12.8000006 Z M7.3426704,17.3473687 L25.7273576,17.3473687 L25.7273576,19.0315793 L7.3426704,19.0315793 L7.3426704,17.3473687 Z M7.3426704,21.8947352 L25.7273576,21.8947352 L25.7273576,23.5789458 L7.3426704,23.5789458 L7.3426704,21.8947352 Z M7.43137255,26.2736849 L16.535014,26.2736849 L16.535014,27.9578954 L7.43137255,27.9578954 L7.43137255,26.2736849 Z",
  download: {
    path:
      "M26 0c7.264 0 13.323 5.164 14.704 12.022C47.004 12.384 52 17.609 52 24c0 6.627-5.373 12-12 12H12C5.373 36 0 30.627 0 24c0-6.391 4.997-11.616 11.297-11.98C12.677 5.164 18.736 0 26 0zm0 6a3 3 0 00-3 3v13.649l-5.232-5.511-.13-.128a2.409 2.409 0 00-3.406.128c-.976 1.028-.976 2.696 0 3.724l10 10.533.13.129a2.409 2.409 0 003.406-.129l10-10.533.122-.138c.852-1.034.812-2.602-.122-3.586l-.13-.128a2.409 2.409 0 00-3.406.128L29 22.649V9a3 3 0 00-3-3z",
    attrs: { viewBox: "0 0 52 32" },
  },
  edit_document:
    "M19.27 20.255l-5.642 2.173 1.75-6.085L28.108 3.45 32 7.363 19.27 20.255zM20.442 6.9l-2.044-2.049H4.79v23.29h18.711v-6.577l4.787-4.83V31a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2h18.024a1 1 0 0 1 .711.297L23.85 3.45 20.442 6.9z",
  ellipsis:
    "M3.613 19.226a3.613 3.613 0 1 0 0-7.226 3.613 3.613 0 0 0 0 7.226zM28.387 19.226a3.613 3.613 0 1 0 0-7.226 3.613 3.613 0 0 0 0 7.226zM19.613 15.613a3.613 3.613 0 1 1-7.226 0 3.613 3.613 0 0 1 7.226 0z",
  embed:
    "M12.734 9.333L6.099 16l6.635 6.667a2.547 2.547 0 0 1 0 3.59 2.518 2.518 0 0 1-3.573 0L.74 17.795a2.547 2.547 0 0 1 0-3.59L9.16 5.743a2.518 2.518 0 0 1 3.573 0 2.547 2.547 0 0 1 0 3.59zm6.527 13.339l6.64-6.71-6.63-6.623a2.547 2.547 0 0 1-.01-3.59 2.518 2.518 0 0 1 3.573-.01l8.42 8.412c.99.988.995 2.596.011 3.59l-8.42 8.51a2.518 2.518 0 0 1-3.574.01 2.547 2.547 0 0 1-.01-3.59z",
  empty: " ",
  enter_or_return:
    "M6.81 16.784l6.14-4.694a1.789 1.789 0 0 0 .341-2.49 1.748 1.748 0 0 0-2.464-.344L.697 17a1.788 1.788 0 0 0-.01 2.826l10.058 7.806c.77.598 1.875.452 2.467-.326a1.79 1.79 0 0 0-.323-2.492l-5.766-4.475h23.118c.971 0 1.759-.796 1.759-1.777V6.777C32 5.796 31.212 5 30.24 5c-.971 0-1.759.796-1.759 1.777v10.007H6.811z",
  expand:
    "M27.448 13.42a2.051 2.051 0 0 0 4.101 0V2.052A2.05 2.05 0 0 0 29.5 0h-11.37a2.05 2.05 0 0 0 0 4.102h6.418L18.46 10.19a2.051 2.051 0 0 0 2.901 2.9l6.088-6.088v6.419zM4.102 18.58a2.051 2.051 0 0 0-4.102 0v11.369A2.05 2.05 0 0 0 2.051 32h11.37a2.051 2.051 0 1 0 0-4.102H7.002l6.088-6.087a2.05 2.05 0 1 0-2.9-2.901l-6.088 6.088v-6.419z",
  expand_arrow: "M16.429 28.429L.429 5.57h32z",
  external:
    "M13.7780693,4.44451732 L5.1588494,4.44451732 C2.32615959,4.44451732 0,6.75504816 0,9.60367661 L0,25.1192379 C0,27.9699171 2.30950226,30.2783972 5.1588494,30.2783972 L18.9527718,30.2783972 C21.7854617,30.2783972 24.1116212,27.9678664 24.1116212,25.1192379 L24.1116212,19.9448453 L20.6671039,19.9448453 L20.6671039,25.1192379 C20.6671039,26.0662085 19.882332,26.8338799 18.9527718,26.8338799 L5.1588494,26.8338799 C4.21204994,26.8338799 3.44451732,26.0677556 3.44451732,25.1192379 L3.44451732,9.60367661 C3.44451732,8.656706 4.22928927,7.88903464 5.1588494,7.88903464 L13.7780693,7.88903464 L13.7780693,4.44451732 L13.7780693,4.44451732 Z M30.9990919,14.455325 L30.9990919,1 L17.5437669,1 L22.4834088,5.93964193 L17.2225866,11.2004641 L20.8001918,14.7780693 L26.061014,9.51724709 L30.9990919,14.455325 L30.9990919,14.455325 L30.9990919,14.455325 Z",
  eye:
    "M30.622 18.49c-.549.769-1.46 1.86-2.737 3.273-1.276 1.414-2.564 2.614-3.866 3.602-2.297 1.757-4.963 2.635-8 2.635-3.062 0-5.741-.878-8.038-2.635-1.302-.988-2.59-2.188-3.866-3.602-1.276-1.413-2.188-2.504-2.737-3.272-.549-.769-.9-1.277-1.053-1.524-.433-.63-.433-1.276 0-1.934.128-.247.472-.755 1.034-1.524.561-.768 1.48-1.852 2.756-3.252 1.276-1.4 2.564-2.593 3.866-3.581C10.303 4.892 12.982 4 16.019 4c3.011 0 5.678.892 8 2.676 1.302.988 2.59 2.182 3.866 3.581 1.276 1.4 2.195 2.484 2.756 3.252.562.769.906 1.277 1.034 1.524.433.63.433 1.276 0 1.934-.153.247-.504.755-1.053 1.524zm-1.516-3.214c-.248.376-.248 1.089.034 1.499l-.11-.16-.088-.17a21.93 21.93 0 0 0-.784-1.121c-.483-.66-1.338-1.67-2.546-2.995-1.154-1.266-2.306-2.333-3.466-3.214-1.781-1.368-3.788-2.04-6.127-2.04-2.365 0-4.385.673-6.179 2.05-1.146.87-2.298 1.938-3.452 3.204-1.208 1.325-2.063 2.334-2.546 2.995a21.93 21.93 0 0 0-.784 1.12l-.075.145-.09.135c.249-.376.249-1.089-.033-1.499l.08.122c.105.17.432.644.941 1.356.466.653 1.313 1.666 2.517 3 1.152 1.275 2.3 2.346 3.451 3.22 1.752 1.339 3.773 2.001 6.17 2.001 2.37 0 4.379-.661 6.14-2.008 1.143-.867 2.291-1.938 3.443-3.214 1.204-1.333 2.05-2.346 2.517-2.999.509-.712.836-1.186.942-1.356l.045-.071zm-17.353 5.663C10.584 19.709 10 18.237 10 16.522c0-1.744.584-3.224 1.753-4.439 1.168-1.215 2.59-1.822 4.268-1.822 1.65 0 3.058.607 4.226 1.822C21.416 13.298 22 14.778 22 16.522c0 1.715-.584 3.187-1.753 4.417-1.168 1.229-2.577 1.844-4.226 1.844-1.677 0-3.1-.615-4.268-1.844zm6.265-2.12c.624-.655.906-1.368.906-2.297 0-.957-.281-1.67-.893-2.307-.592-.616-1.203-.879-2.01-.879-.84 0-1.462.266-2.052.88-.612.636-.893 1.35-.893 2.306 0 .929.282 1.642.906 2.298.59.62 1.207.887 2.039.887.8 0 1.405-.264 1.997-.887z",
  eye_crossed_out:
    "M21.775 3.183C20.007 2.393 18.082 2 16.017 2c-3.043 0-5.778.84-8.151 2.54-1.263.896-2.5 1.967-3.711 3.207-1.168 1.196-2.05 2.162-2.61 2.88-.457.582-.828 1.078-1.025 1.411-.305.451-.52.993-.52 1.607 0 .632.228 1.188.557 1.645.177.263.52.723.995 1.343.552.722 1.43 1.697 2.598 2.905.137.141.274.28.411.417l2.084-2.03c-.135-.134-.27-.27-.404-.41-1.152-1.19-1.933-2.067-2.378-2.65a30.87 30.87 0 0 1-.901-1.213l-.01-.016.033-.047.038-.069.014-.023.046-.07c.04-.06.095-.138.166-.236.142-.197.337-.452.586-.771.46-.587 1.249-1.46 2.4-2.64C7.344 8.646 8.45 7.693 9.552 6.912l.006-.005c1.848-1.325 3.984-1.998 6.46-1.998 1.236 0 2.388.17 3.463.51l2.295-2.236zm-5.093 4.962a6.109 6.109 0 0 0-.668-.036c-1.53 0-2.883.536-3.972 1.6-1.09 1.064-1.652 2.402-1.652 3.927 0 .207.01.41.031.61l6.26-6.1zm-1.583 10.95l6.453-6.29c.039.27.058.547.058.83 0 1.514-.566 2.841-1.646 3.908-1.083 1.07-2.426 1.619-3.95 1.619a6.1 6.1 0 0 1-.915-.068zm-2.78 2.707c1.133.373 2.363.562 3.698.562 2.482 0 4.606-.665 6.428-1.965l.004-.003c1.1-.78 2.204-1.737 3.31-2.88 1.152-1.192 1.933-2.068 2.378-2.65.506-.661.794-1.052.901-1.213l.01-.016-.025-.035-.046-.082-.014-.023a7.635 7.635 0 0 0-.212-.306 28.444 28.444 0 0 0-.586-.771c-.46-.587-1.249-1.46-2.4-2.64a29.152 29.152 0 0 0-.548-.545l2.085-2.031c.181.177.363.358.543.543 1.168 1.196 2.05 2.162 2.61 2.88.451.575.819 1.066 1.018 1.399.313.449.527.99.527 1.602 0 .633-.23 1.19-.55 1.65-.174.261-.52.726-1.002 1.355-.552.722-1.43 1.697-2.598 2.905-1.213 1.253-2.45 2.333-3.717 3.23-2.353 1.679-5.077 2.505-8.116 2.505-2.161 0-4.162-.412-5.98-1.246l2.282-2.225zM28.617 3L5 26.618l-2.121-2.122L26.496.88 28.617 3z",
  field:
    "M27 25v7H5V1h22v24zm-3 0H8v4h16v-4zm0-3v-4H8v4h16zM8 15h16v-4H8v4zm0-7h16V4H8v4z",
  fields:
    "M0,0 L7.51851852,0 L7.51851852,3.2 L0,3.2 L0,0 Z M10.7407407,0 L18.2592593,0 L18.2592593,3.2 L10.7407407,3.2 L10.7407407,0 Z M21.4814815,0 L29,0 L29,3.2 L21.4814815,3.2 L21.4814815,0 Z M0,5.33333333 L7.51851852,5.33333333 L7.51851852,29.8666667 L3.85540334,32 L0,29.8666667 L0,5.33333333 Z M10.7407407,5.33333333 L18.2592593,5.33333333 L18.2592593,29.8666667 L14.5690136,32 L10.7407407,29.8666667 L10.7407407,5.33333333 Z M21.4814815,5.33333333 L29,5.33333333 L29,29.8666667 L25.2114718,32 L21.4814815,29.8666667 L21.4814815,5.33333333 Z",
  filter:
    "M3.556 4h24.888a3.556 3.556 0 1 1 0 7.111H3.556a3.556 3.556 0 1 1 0-7.111zm4 11.556h16.888a2.222 2.222 0 1 1 0 4.444H7.556a2.222 2.222 0 0 1 0-4.444zM12 24.444h8a2.222 2.222 0 0 1 0 4.445h-8a2.222 2.222 0 0 1 0-4.445z",
  funnel:
    "M3.18586974,3.64621479 C2.93075885,3.28932022 3.08031197,3 3.5066208,3 L28.3780937,3 C28.9190521,3 29.0903676,3.34981042 28.7617813,3.77995708 L18.969764,16.5985181 L18.969764,24.3460671 C18.969764,24.8899179 18.5885804,25.5564176 18.133063,25.8254534 C18.133063,25.8254534 12.5698889,29.1260709 12.5673818,28.9963552 C12.4993555,25.4767507 12.5749031,16.7812673 12.5749031,16.7812673 L3.18586974,3.64621479 Z",
  funnel_outline: {
    path:
      "M3.186 3.646C2.93 3.29 3.08 3 3.506 3h24.872c.541 0 .712.35.384.78L18.97 16.599v7.747c0 .544-.381 1.21-.837 1.48 0 0-5.563 3.3-5.566 3.17-.068-3.52.008-12.215.008-12.215L3.185 3.646z",
    attrs: {
      stroke: "currentcolor",
      strokeWidth: "4",
      fill: "none",
      fillRule: "evenodd",
    },
  },
  folder:
    "M0 5l.01 21.658a2 2 0 0 0 2 1.999H30a2 2 0 0 0 2-2V7.705a2 2 0 0 0-2-2H17.51a1 1 0 0 1-.924-.615l-.614-1.474A1 1 0 0 0 15.049 3H1.999a2 2 0 0 0-2 2z",
  gauge:
    "M5.197 29.803A15.958 15.958 0 0 1 0 18C0 9.163 7.163 2 16 2s16 7.163 16 16a15.96 15.96 0 0 1-5.344 11.936L22.983 26.5A10.978 10.978 0 0 0 27 18c0-6.075-4.925-11-11-11S5 11.925 5 18c0 3.292 1.446 6.246 3.738 8.262l-3.54 3.54zM13 21.25a3.774 3.774 0 0 1 1.122-5.975L23 11l-4.34 9.347a3.455 3.455 0 0 1-5.66.903z",
  gear:
    "M12.088.996c0-.55.441-.996 1.006-.996h6.189c.555 0 1.005.452 1.005 1.007V3.53c0 .556.375 1.235.848 1.524l1.806 1.102c.468.286 1.252.328 1.748.095l2.756-1.292a1.125 1.125 0 0 1 1.417.432l2.979 4.93a1.063 1.063 0 0 1-.307 1.408l-2.147 1.445c-.455.306-.823 1.011-.823 1.55v2.6c0 .55.353 1.278.774 1.614l2.279 1.818c.428.341.512.976.181 1.43l-3.211 4.394c-.328.448-.992.588-1.463.324l-2.27-1.272c-.48-.27-1.238-.242-1.709.071l-2.019 1.344c-.463.309-.839 1.013-.839 1.556v2.4c0 .55-.44.997-1.005.997h-6.19a1.006 1.006 0 0 1-1.005-.997v-2.4c0-.55-.372-1.26-.823-1.58l-1.829-1.295c-.454-.322-1.198-.35-1.664-.06l-2.9 1.808a.985.985 0 0 1-1.361-.325L.309 21.923a1.03 1.03 0 0 1 .318-1.393l2.566-1.666c.463-.3.838-.99.838-1.539v-2.494c0-.55-.391-1.226-.86-1.503L.485 11.74a.99.99 0 0 1-.35-1.36l3.14-5.236c.28-.47.907-.646 1.393-.397l3.308 1.7c.488.25 1.23.175 1.666-.178l1.665-1.345c.432-.348.781-1.074.781-1.627V.996zM16.002 22c3.33 0 6.028-2.686 6.028-6s-2.699-6-6.028-6c-3.329 0-6.027 2.686-6.027 6s2.698 6 6.027 6z",
  grabber:
    "M0,5 L32,5 L32,9.26666667 L0,9.26666667 L0,5 Z M0,13.5333333 L32,13.5333333 L32,17.8 L0,17.8 L0,13.5333333 Z M0,22.0666667 L32,22.0666667 L32,26.3333333 L0,26.3333333 L0,22.0666667 Z",
  grabber2:
    "M9.692 7.385a3.692 3.692 0 1 1 0-7.385 3.692 3.692 0 0 1 0 7.385zm0 12.307a3.692 3.692 0 1 1 0-7.384 3.692 3.692 0 0 1 0 7.384zM22 7.385A3.692 3.692 0 1 1 22 0a3.692 3.692 0 0 1 0 7.385zm0 12.307a3.692 3.692 0 1 1 0-7.384 3.692 3.692 0 0 1 0 7.384zM9.692 32a3.692 3.692 0 1 1 0-7.385 3.692 3.692 0 0 1 0 7.385zM22 32a3.692 3.692 0 1 1 0-7.385A3.692 3.692 0 0 1 22 32z",
  grid:
    "M2 2 L10 2 L10 10 L2 10z M12 2 L20 2 L20 10 L12 10z M22 2 L30 2 L30 10 L22 10z M2 12 L10 12 L10 20 L2 20z M12 12 L20 12 L20 20 L12 20z M22 12 L30 12 L30 20 L22 20z M2 22 L10 22 L10 30 L2 30z M12 22 L20 22 L20 30 L12 30z M22 22 L30 22 L30 30 L22 30z",
  group:
    "M11.044 4.805c4.38-.157 6.166 3.841 6.166 6.134s-1.132 5.67-3.048 7.412c-.424.385-.345 2.822.58 3.218 1.938.83 7.242 2.51 7.443 5.971.224 3.853-6.733 4.244-11.023 4.244S0 31.26 0 28.024c0-1.501.15-2.489 2.625-4.16 2.474-1.67 4.36-2.08 4.77-2.333.412-.254 1.17-1.574.677-3.048 0 0-2.973-3.248-2.973-6.824 0-3.577 1.566-6.698 5.945-6.854zm5.554-.51S17.686 1 21.591 1c3.905 0 5.502 3.217 5.502 5.87s-1.023 5.356-2.623 6.946c-.18.178-.408 1.742.302 2.09.71.347 7.228 2.274 7.228 5.74s-4.39 3.524-7.698 3.856c0 0-.639-3.165-7.78-5.943 0 0 3.315-3.944 3.165-8.697-.151-4.754-3.089-6.568-3.089-6.568z",
  google: {
    svg:
      '<g fill="none" fill-rule="evenodd"><path d="M16 32c4.32 0 7.947-1.422 10.596-3.876l-5.05-3.91c-1.35.942-3.164 1.6-5.546 1.6-4.231 0-7.822-2.792-9.102-6.65l-5.174 4.018C4.356 28.41 9.742 32 16 32z" fill="#34A853"/><path d="M6.898 19.164A9.85 9.85 0 0 1 6.364 16c0-1.102.196-2.169.516-3.164L1.707 8.818A16.014 16.014 0 0 0 0 16c0 2.578.622 5.013 1.707 7.182l5.19-4.018z" fill="#FBBC05"/><path d="M31.36 16.356c0-1.316-.107-2.276-.338-3.272H16v5.938h8.818c-.178 1.476-1.138 3.698-3.271 5.191l5.049 3.911c3.022-2.79 4.764-6.897 4.764-11.768z" fill="#4285F4"/><path d="M16 6.187c3.004 0 5.031 1.297 6.187 2.382l4.515-4.409C23.93 1.582 20.32 0 16 0 9.742 0 4.338 3.591 1.707 8.818l5.173 4.018c1.298-3.858 4.889-6.65 9.12-6.65z" fill="#EA4335"/></g>',
  },
  history: {
    path:
      "M4.03074198,15 C4.54693838,6.62927028 11.4992947,0 20,0 C28.836556,0 36,7.163444 36,16 C36,24.836556 28.836556,32 20,32 C16.9814511,32 14.1581361,31.164104 11.7489039,29.7111608 L14.1120194,26.4586113 C15.8515127,27.4400159 17.8603607,28 20,28 C26.627417,28 32,22.627417 32,16 C32,9.372583 26.627417,4 20,4 C13.7093362,4 8.54922468,8.84046948 8.04107378,15 L11,15 L6,22 L1.34313965,15 L4.03074198,15 Z M22,15.2218254 L24.5913352,17.8131606 L24.5913352,17.8131606 C25.3723838,18.5942092 25.3723838,19.8605392 24.5913352,20.6415878 C23.8176686,21.4152544 22.5633071,21.4152544 21.7896404,20.6415878 C21.7852062,20.6371536 21.7807931,20.6326983 21.7764012,20.6282222 L18.8194549,17.6145768 C18.3226272,17.2506894 18,16.6630215 18,16 L18,10 C18,8.8954305 18.8954305,8 20,8 C21.1045695,8 22,8.8954305 22,10 L22,15.2218254 Z",
    attrs: { viewBox: "0 0 36 33" },
  },
  info:
    "M16 0 A16 16 0 0 1 16 32 A16 16 0 0 1 16 0 M19 15 L13 15 L13 26 L19 26 z M16 6 A3 3 0 0 0 16 12 A3 3 0 0 0 16 6",
  info_outline:
    "M16 29c7.18 0 13-5.82 13-13S23.18 3 16 3 3 8.82 3 16s5.82 13 13 13zm0 3C7.163 32 0 24.837 0 16S7.163 0 16 0s16 7.163 16 16-7.163 16-16 16zm1.697-20h-4.185v14h4.185V12zm.432-3.834c0-.342-.067-.661-.203-.958a2.527 2.527 0 0 0-1.37-1.31 2.613 2.613 0 0 0-.992-.188c-.342 0-.661.062-.959.189a2.529 2.529 0 0 0-1.33 1.309c-.13.297-.195.616-.195.958 0 .334.065.646.196.939.13.292.31.549.54.77.23.22.492.395.79.526.297.13.616.196.958.196.351 0 .682-.066.992-.196.31-.13.583-.306.817-.527a2.47 2.47 0 0 0 .553-.77c.136-.292.203-.604.203-.938z",
  insight:
    "M12.6325203 19.3674797 0 16 12.6325203 12.6325203 16 0 19.3674797 12.6325203 32 16 19.3674797 19.3674797 16 32z",
  int: {
    path:
      "M15.141,15.512 L14.294,20 L13.051,20 C12.8309989,20 12.6403341,19.9120009 12.479,19.736 C12.3176659,19.5599991 12.237,19.343668 12.237,19.087 C12.237,19.0503332 12.2388333,19.0155002 12.2425,18.9825 C12.2461667,18.9494998 12.2516666,18.9146668 12.259,18.878 L12.908,15.512 L10.653,15.512 L10.015,19.01 C9.94899967,19.3620018 9.79866784,19.6149992 9.564,19.769 C9.32933216,19.9230008 9.06900143,20 8.783,20 L7.584,20 L8.42,15.512 L7.155,15.512 C6.92033216,15.512 6.74066729,15.4551672 6.616,15.3415 C6.49133271,15.2278328 6.429,15.0390013 6.429,14.775 C6.429,14.6723328 6.43999989,14.5550007 6.462,14.423 L6.605,13.554 L8.695,13.554 L9.267,10.518 L6.913,10.518 L7.122,9.385 C7.17333359,9.10633194 7.28699912,8.89916734 7.463,8.7635 C7.63900088,8.62783266 7.92499802,8.56 8.321,8.56 L9.542,8.56 L10.224,5.018 C10.282667,4.7246652 10.4183323,4.49733414 10.631,4.336 C10.8436677,4.17466586 11.0929986,4.094 11.379,4.094 L12.611,4.094 L11.775,8.56 L14.019,8.56 L14.866,4.094 L16.076,4.094 C16.3326679,4.094 16.5416659,4.1673326 16.703,4.314 C16.8643341,4.4606674 16.945,4.64766553 16.945,4.875 C16.945,4.9483337 16.9413334,5.00333315 16.934,5.04 L16.252,8.56 L18.485,8.56 L18.276,9.693 C18.2246664,9.97166806 18.1091676,10.1788327 17.9295,10.3145 C17.7498324,10.4501673 17.4656686,10.518 17.077,10.518 L15.977,10.518 L15.416,13.554 L16.978,13.554 C17.2126678,13.554 17.3904994,13.6108328 17.5115,13.7245 C17.6325006,13.8381672 17.693,14.0306653 17.693,14.302 C17.693,14.4046672 17.6820001,14.5219993 17.66,14.654 L17.528,15.512 L15.141,15.512 Z M10.928,13.554 L13.183,13.554 L13.744,10.518 L11.5,10.518 L10.928,13.554 Z",
    attrs: { viewBox: "0 0 24 24" },
  },
  io:
    "M1,9 L6,9 L6,24 L1,24 L1,9 Z M31,16 C31,11.581722 27.418278,8 23,8 C18.581722,8 15,11.581722 15,16 C15,20.418278 18.581722,24 23,24 C27.418278,24 31,20.418278 31,16 Z M19,16 C19,13.790861 20.790861,12 23,12 C25.209139,12 27,13.790861 27,16 C27,18.209139 25.209139,20 23,20 C20.790861,20 19,18.209139 19,16 Z M15.3815029,9 L13.4537572,9 L7,23.5 L8.92774566,23.5 L15.3815029,9 Z",
  join_full_outer:
    "M16.044 7.903A9.955 9.955 0 0 1 22 5.936c5.523 0 10 4.477 10 10s-4.477 10-10 10a9.955 9.955 0 0 1-5.903-1.928l-.097.065-.051-.034A9.955 9.955 0 0 1 10 26C4.477 26 0 21.523 0 16S4.477 6 10 6c2.211 0 4.255.718 5.911 1.933l.089-.06.044.03zm0 0l-.087.064-.046-.034-.25.168c-2.648 1.78-4.261 4.695-4.261 7.872 0 3.177 1.613 6.092 4.262 7.873l.287.193.094-.07.054.04.241-.163c2.649-1.781 4.262-4.696 4.262-7.873 0-3.177-1.613-6.091-4.262-7.872l-.294-.198zm-3.444 8.07c0-2.643 1.276-5.08 3.4-6.657 2.124 1.578 3.4 4.014 3.4 6.657 0 2.644-1.276 5.08-3.4 6.658-2.124-1.578-3.4-4.014-3.4-6.658z",
  join_inner:
    "M14.923 7.148c-.427.315-.826.66-1.195 1.03a8.865 8.865 0 0 0-3.546-.734C5.35 7.444 1.444 11.28 1.444 16c0 4.72 3.906 8.556 8.738 8.556 1.547 0 2.999-.393 4.258-1.083.26.217.533.423.816.616l.454.31A10.268 10.268 0 0 1 10.182 26C4.559 26 0 21.523 0 16S4.559 6 10.182 6c1.712 0 3.325.415 4.74 1.148zm1.879 0c.434.315.84.66 1.217 1.03a9.172 9.172 0 0 1 3.611-.734c4.921 0 8.9 3.836 8.9 8.556 0 4.72-3.979 8.556-8.9 8.556a9.137 9.137 0 0 1-4.337-1.083c-.265.217-.543.423-.83.616L16 24.4A10.6 10.6 0 0 0 21.63 26C27.357 26 32 21.523 32 16S27.357 6 21.63 6c-1.743 0-3.386.415-4.828 1.148zM16 8c2.418 1.651 4 4.395 4 7.5 0 3.105-1.582 5.849-4 7.5-2.418-1.651-4-4.395-4-7.5 0-3.105 1.582-5.849 4-7.5z",
  join_left_outer:
    "M17.077 7.148A10.285 10.285 0 0 1 21.818 6C27.441 6 32 10.477 32 16s-4.559 10-10.182 10c-2.038 0-3.936-.588-5.528-1.6l.454-.31c.283-.194.555-.4.816-.617a8.842 8.842 0 0 0 4.258 1.083c4.832 0 8.738-3.836 8.738-8.556 0-4.72-3.906-8.556-8.738-8.556a8.865 8.865 0 0 0-3.546.733 10.65 10.65 0 0 0-1.195-1.03zM15.71 24.399A10.268 10.268 0 0 1 10.182 26C4.559 26 0 21.523 0 16S4.559 6 10.182 6c1.712 0 3.325.415 4.74 1.148-2.643 1.957-4.241 5.022-4.241 8.352 0 3.468 1.733 6.649 4.575 8.59l.454.31zM16 8c2.418 1.651 4 4.395 4 7.5 0 3.105-1.582 5.849-4 7.5-2.418-1.651-4-4.395-4-7.5 0-3.105 1.582-5.849 4-7.5z",
  json:
    "M28 10.105v18.728A3.166 3.166 0 0 1 24.834 32H6.166A3.163 3.163 0 0 1 3 28.844V3.156A3.163 3.163 0 0 1 6.16 0h13.553V10.105H28zm-.215-1.684h-6.4V.311l6.4 8.11zM10.894 19.233v-.218c1.162-.13 1.79-.718 1.79-1.703v-1.394c0-.964.322-1.333 1.19-1.333h.3v-1.45h-.505c-2.03 0-2.885.766-2.885 2.55v1.094c0 1.005-.451 1.388-1.613 1.395v1.9c1.169.007 1.613.39 1.613 1.395v1.066c0 1.805.862 2.584 2.885 2.584h.506v-1.45h-.301c-.861 0-1.19-.361-1.19-1.332v-1.401c0-.992-.628-1.573-1.79-1.703zm8.184-.212v.22c-1.162.122-1.791.71-1.791 1.701v1.395c0 .964-.321 1.333-1.19 1.333h-.3v1.45h.505c2.03 0 2.892-.766 2.892-2.55v-1.094c0-1.012.444-1.388 1.607-1.395v-1.9c-1.17-.014-1.607-.39-1.607-1.395v-1.073c0-1.798-.861-2.577-2.892-2.577h-.505v1.449h.3c.862 0 1.19.362 1.19 1.326v1.408c0 .985.629 1.573 1.79 1.702z",
  key: {
    path:
      "M11.5035746,7.9975248 C10.8617389,5.26208051 13.0105798,1.44695394 16.9897081,1.44695394 C20.919315,1.44695394 23.1811258,5.37076315 22.2565255,8.42469226 C21.3223229,7.86427598 20.2283376,7.54198814 19.0589133,7.54198814 C17.3567818,7.54198814 15.8144729,8.22477622 14.6920713,9.33083544 C14.4930673,9.31165867 14.2913185,9.30184676 14.087273,9.30184676 C10.654935,9.30184676 7.87247532,12.0782325 7.87247532,15.5030779 C7.87247532,17.1058665 8.48187104,18.5666337 9.48208198,19.6672763 L8.98356958,20.658345 L9.19925633,22.7713505 L7.5350473,23.4587525 C7.37507672,23.5248284 7.30219953,23.707739 7.37031308,23.8681037 L7.95501877,25.2447188 L6.28291833,25.7863476 C6.10329817,25.8445303 6.01548404,26.0233452 6.06755757,26.1919683 L6.54426059,27.7356153 L5.02460911,28.2609385 C4.86686602,28.3154681 4.7743984,28.501653 4.83652351,28.6704172 L6.04508836,31.95351 C6.10987939,32.1295162 6.29662279,32.2151174 6.46814592,32.160881 L9.48965349,31.2054672 C9.66187554,31.1510098 9.86840241,30.9790422 9.95250524,30.8208731 L14.8228902,21.6613229 C15.8820565,21.5366928 16.8596786,21.1462953 17.6869404,20.558796 C17.5652123,20.567429 17.4424042,20.5718139 17.318643,20.5718139 C14.2753735,20.5718139 11.8083161,17.9204625 11.8083161,14.6498548 C11.8083161,12.518229 12.8562751,10.6496514 14.428709,9.60671162 C13.4433608,10.7041074 12.8441157,12.1538355 12.8441157,13.7432193 C12.8441157,16.9974306 15.3562245,19.6661883 18.5509945,19.9240384 L19.1273026,21.5699573 L20.7971002,22.8826221 L20.1355191,24.5572635 C20.0719252,24.7182369 20.1528753,24.8977207 20.3155476,24.9601226 L21.7119724,25.4957977 L20.9400489,27.0748531 C20.8571275,27.2444782 20.9247553,27.4318616 21.082226,27.5115385 L22.5237784,28.2409344 L21.8460256,29.6990003 C21.7756734,29.8503507 21.8453702,30.0462011 22.0099247,30.1187455 L25.2111237,31.5300046 C25.3827397,31.6056621 25.5740388,31.5307937 25.6541745,31.3697345 L27.0658228,28.5325576 C27.1462849,28.3708422 27.1660474,28.1028205 27.1106928,27.9324485 L23.8023823,17.7500271 C24.7201964,16.6692906 25.273711,15.270754 25.273711,13.7432193 C25.273711,12.0364592 24.582689,10.4907436 23.4645818,9.36943333 C25.0880384,5.38579616 22.187534,0 16.9897081,0 C12.1196563,0 9.42801686,4.46934651 10.0266074,7.9975248 L11.5035746,7.9975248 Z M19.0589133,14.7767578 C20.203026,14.7767578 21.1305126,13.8512959 21.1305126,12.7096808 C21.1305126,11.5680656 20.203026,10.6426037 19.0589133,10.6426037 C17.9148007,10.6426037 16.9873141,11.5680656 16.9873141,12.7096808 C16.9873141,13.8512959 17.9148007,14.7767578 19.0589133,14.7767578 Z",
    attrs: { fillRule: "evenodd" },
  },
  label:
    "M14.577 31.042a2.005 2.005 0 0 1-2.738-.733L1.707 12.759c-.277-.477-.298-1.265-.049-1.757L6.45 1.537C6.7 1.044 7.35.67 7.9.7l10.593.582c.551.03 1.22.44 1.498.921l10.132 17.55a2.002 2.002 0 0 1-.734 2.737l-14.812 8.552zm.215-22.763a3.016 3.016 0 1 0-5.224 3.016 3.016 3.016 0 0 0 5.224-3.016z",
  ldap: {
    path:
      "M1.006 3h13.702c.554 0 1.178.41 1.39.915l.363.874c.21.504.827.915 1.376.915h13.169c.54 0 .994.448.994 1.001v20.952a.99.99 0 0 1-.992 1H1.002c-.54 0-.993-.45-.993-1.005l-.01-23.646C0 3.446.45 3 1.007 3zM16.5 19.164c1.944 0 3.52-1.828 3.52-4.082 0-2.254-1.576-4.082-3.52-4.082-1.945 0-3.52 1.828-3.52 4.082 0 2.254 1.575 4.082 3.52 4.082zm6.5 4.665c0-1.872-1.157-3.521-2.913-4.484-.927.97-2.192 1.568-3.587 1.568s-2.66-.597-3.587-1.568C11.157 20.308 10 21.957 10 23.83h13z",
    attrs: { fillRule: "evenodd" },
  },
  lightbulb:
    "M16.1 11.594L18.756 8.9a1.03 1.03 0 0 1 1.446-.018c.404.39.412 1.03.018 1.43l-3.193 3.24v4.975c0 .559-.458 1.011-1.022 1.011a1.017 1.017 0 0 1-1.023-1.01v-5.17l-3.003-3.046c-.394-.4-.386-1.04.018-1.43a1.03 1.03 0 0 1 1.446.018l2.657 2.695zM11.03 28.815h9.938a1.01 1.01 0 1 1 0 2.02 376.72 376.72 0 0 0-2.964.002C18.005 31.857 16.767 32 16 32c-.767 0-1.993-.139-1.993-1.163H11.03a1.011 1.011 0 0 1 0-2.022zm0-3.033h9.938a1.011 1.011 0 0 1 0 2.022H11.03a1.011 1.011 0 1 1 0-2.022zM8.487 20.43A11.659 11.659 0 0 1 4.5 11.627C4.5 5.214 9.64 0 16 0s11.5 5.214 11.5 11.627c0 3.43-1.481 6.617-3.987 8.803v1.308c0 1.954-1.601 3.538-3.577 3.538h-7.872c-1.976 0-3.577-1.584-3.577-3.538V20.43zm2.469-1.915l.597.455v2.768c0 .279.23.505.511.505h7.872a.508.508 0 0 0 .51-.505V18.97l.598-.455a8.632 8.632 0 0 0 3.39-6.888c0-4.755-3.785-8.594-8.434-8.594-4.649 0-8.433 3.84-8.433 8.594a8.632 8.632 0 0 0 3.389 6.888z",
  link:
    "M12.56 17.04c-1.08 1.384-1.303 1.963 1.755 4.04 3.058 2.076 7.29.143 8.587-1.062 1.404-1.304 4.81-4.697 7.567-7.842 2.758-3.144 1.338-8.238-.715-9.987-5.531-4.71-9.5-.554-11.088.773-2.606 2.176-5.207 5.144-5.207 5.144s1.747-.36 2.784 0c1.036.36 2.102.926 2.102.926l4.003-3.969s2.367-1.907 4.575 0 .674 4.404 0 5.189c-.674.784-6.668 6.742-6.668 6.742s-1.52.811-2.37.811c-.85 0-2.582-.528-2.582-.932 0-.405-1.665-1.22-2.744.166zm7.88-2.08c1.08-1.384 1.303-1.963-1.755-4.04-3.058-2.076-7.29-.143-8.587 1.062-1.404 1.304-4.81 4.697-7.567 7.842-2.758 3.144-1.338 8.238.715 9.987 5.531 4.71 9.5.554 11.088-.773 2.606-2.176 5.207-5.144 5.207-5.144s-1.747.36-2.784 0a17.379 17.379 0 0 1-2.102-.926l-4.003 3.969s-2.367 1.907-4.575 0-.674-4.404 0-5.189c.674-.784 6.668-6.742 6.668-6.742s1.52-.811 2.37-.811c.85 0 2.582.528 2.582.932 0 .405 1.665 1.22 2.744-.166z",
  line:
    "M18.867 16.377l-3.074-3.184-.08.077-.002-.002.01-.01-.53-.528-.066-.07-.001.002-2.071-2.072L-.002 23.645l2.668 2.668 10.377-10.377 3.074 3.183.08-.076.001.003-.008.008.5.501.094.097.002-.001 2.072 2.072L31.912 8.669 29.244 6 18.867 16.377z",
  lineandbar:
    "M3.056 24.041h6.706v7.78H3.056v-7.78zm10.06-6.483h6.706v14.264h-6.707V17.558zm9.8-4.631h6.707v18.895h-6.706V12.927zm-11.812-1.582l-9.061 6.412L0 14.864l10.517-7.442 7.144 2.353L29.425 1l2.115 2.84-13.238 9.876-7.198-2.37z",
  list:
    "M3 8 A3 3 0 0 0 9 8 A3 3 0 0 0 3 8 M12 6 L28 6 L28 10 L12 10z M3 16 A3 3 0 0 0 9 16 A3 3 0 0 0 3 16 M12 14 L28 14 L28 18 L12 18z M3 24 A3 3 0 0 0 9 24 A3 3 0 0 0 3 24 M12 22 L28 22 L28 26 L12 26z",
  location: {
    path:
      "M19.4917776,13.9890373 C20.4445763,12.5611169 21,10.8454215 21,9 C21,4.02943725 16.9705627,0 12,0 C7.02943725,0 3,4.02943725 3,9 C3,10.8454215 3.5554237,12.5611168 4.50822232,13.9890371 L4.49999986,14.0000004 L4.58010869,14.0951296 C4.91305602,14.5790657 5.29212089,15.0288088 5.71096065,15.4380163 L12.5,23.5 L19.4999993,13.9999996 L19.4917776,13.9890373 L19.4917776,13.9890373 Z M12,12 C13.6568542,12 15,10.6568542 15,9 C15,7.34314575 13.6568542,6 12,6 C10.3431458,6 9,7.34314575 9,9 C9,10.6568542 10.3431458,12 12,12 Z",
    attrs: { viewBox: "0 0 24 24", fillRule: "evenodd" },
  },
  lock: {
    path:
      "M7.30894737,12.4444444 L4.91725192,12.4444444 C3.2943422,12.4444444 2,13.7457504 2,15.3509926 L2,29.0934518 C2,30.7017608 3.30609817,32 4.91725192,32 L27.0827481,32 C28.7056578,32 30,30.6986941 30,29.0934518 L30,15.3509926 C30,13.7426837 28.6939018,12.4444444 27.0827481,12.4444444 L24.6910526,12.4444444 L24.6910526,7.44176009 C24.6910526,3.33441301 21.3568185,0 17.2438323,0 L14.7561677,0 C10.6398254,0 7.30894737,3.33178948 7.30894737,7.44176009 L7.30894737,12.4444444 Z M10.8678947,8.21027479 C10.8678947,5.65010176 12.9450109,3.57467145 15.5045167,3.57467145 L16.4954833,3.57467145 C19.0562189,3.57467145 21.1321053,5.65531119 21.1321053,8.21027479 L21.1321053,12.8458781 L10.8678947,12.8458781 L10.8678947,8.21027479 Z M16,26.6666667 C17.9329966,26.6666667 19.5,25.0747902 19.5,23.1111111 C19.5,21.147432 17.9329966,19.5555556 16,19.5555556 C14.0670034,19.5555556 12.5,21.147432 12.5,23.1111111 C12.5,25.0747902 14.0670034,26.6666667 16,26.6666667 Z",
    attrs: { fillRule: "evenodd" },
  },
  lock_outline:
    "M7 12H5.546A3.548 3.548 0 0 0 2 15.553v12.894A3.547 3.547 0 0 0 5.546 32h20.908C28.414 32 30 30.41 30 28.447V15.553A3.547 3.547 0 0 0 26.454 12H25V8.99C25 4.029 20.97 0 16 0c-4.972 0-9 4.025-9 8.99V12zm4-3.766c0-2.338 1.89-4.413 4.219-4.634L16 3.525l.781.075C19.111 3.82 21 5.896 21 8.234V12H11V8.234zm-5 9.537C6 16.793 6.796 16 7.775 16h16.45c.98 0 1.775.787 1.775 1.77v8.46c0 .977-.796 1.77-1.775 1.77H7.775A1.77 1.77 0 0 1 6 26.23v-8.46zM16 25a3 3 0 1 0 0-6 3 3 0 0 0 0 6z",
  mail: {
    path:
      "M36 0a6 6 0 016 6v20a6 6 0 01-6 6H6a6 6 0 01-6-6V6a6 6 0 016-6h30zm-3.292 5.473L21 15.38 9.292 5.473a2 2 0 10-2.584 3.054l13 11a2 2 0 002.584 0l13-11a2 2 0 10-2.584-3.054z",
    attrs: { viewBox: "0 0 42 32" },
  },
  moon:
    "M11.6291702,1.84239429e-11 C19.1234093,1.22958025 24.8413559,7.73631246 24.8413559,15.5785426 C24.8413559,24.2977683 17.7730269,31.3660972 9.05380131,31.3660972 C7.28632096,31.3660972 5.58667863,31.0756481 4,30.5398754 C11.5007933,28.2096945 16.9475786,21.2145715 16.9475786,12.9472835 C16.9475786,7.90001143 14.9174312,3.32690564 11.6291702,1.70246039e-11 L11.6291702,1.84239429e-11 Z",
  move:
    "M23 27h-8v-5h8v-4l8 6-8 7v-4zM17.266 0h.86a2 2 0 0 1 1.42.592L27.49 8.61a2 2 0 0 1 .58 1.407v6h-5.01v-5.065L17.133 5H0V2a2 2 0 0 1 2-2h15.266zM5 27h7v5H2a2 2 0 0 1-2-2V5h5v22z",
  new_folder: {
    path:
      "M0 6a4 4 0 0 1 4-4h5.892a4 4 0 0 1 2.058.57L16 5h12a4 4 0 0 1 4 4v17a4 4 0 0 1-4 4H4a4 4 0 0 1-4-4V6zm16 6c.621 0 1.125.504 1.125 1.125v3.75h3.75a1.125 1.125 0 0 1 0 2.25h-3.75v3.75a1.125 1.125 0 0 1-2.25 0v-3.75h-3.75a1.125 1.125 0 0 1 0-2.25h3.75v-3.75c0-.621.504-1.125 1.125-1.125z",
    attrs: { fillRule: "evenodd", clipRule: "evenodd" },
  },
  notebook:
    "M10.105 15.023c0-1.048.859-1.898 1.905-1.898h18.085c1.052 0 1.905.855 1.905 1.898v2.954a1.905 1.905 0 0 1-1.905 1.898H12.01a1.905 1.905 0 0 1-1.905-1.898v-2.954zm0 10.125c0-1.048.844-1.898 1.901-1.898h6.304c1.05 0 1.9.855 1.9 1.898v2.954A1.895 1.895 0 0 1 18.31 30h-6.304c-1.05 0-1.9-.855-1.9-1.898v-2.954zM0 15.023a1.9 1.9 0 0 1 1.895-1.898h2.947a1.9 1.9 0 0 1 1.895 1.898v2.954a1.9 1.9 0 0 1-1.895 1.898H1.895A1.9 1.9 0 0 1 0 17.977v-2.954zm0 10.125a1.9 1.9 0 0 1 1.895-1.898h2.947a1.9 1.9 0 0 1 1.895 1.898v2.954A1.9 1.9 0 0 1 4.842 30H1.895A1.9 1.9 0 0 1 0 28.102v-2.954zm10.105-20.25c0-1.048.848-1.898 1.89-1.898h11.379c1.043 0 1.89.855 1.89 1.898v2.954a1.895 1.895 0 0 1-1.89 1.898h-11.38a1.897 1.897 0 0 1-1.889-1.898V4.898zM0 4.898A1.9 1.9 0 0 1 1.895 3h2.947a1.9 1.9 0 0 1 1.895 1.898v2.954A1.9 1.9 0 0 1 4.842 9.75H1.895A1.9 1.9 0 0 1 0 7.852V4.898z",
  number:
    "M0 .503A.5.5 0 0 1 .503 0h30.994A.5.5 0 0 1 32 .503v30.994a.5.5 0 0 1-.503.503H.503A.5.5 0 0 1 0 31.497V.503zM8.272 22V10.8H6.464c-.064.427-.197.784-.4 1.072-.203.288-.45.52-.744.696a2.984 2.984 0 0 1-.992.368c-.368.07-.75.099-1.144.088v1.712H6V22h2.272zm2.96-5.648c0 1.12.11 2.056.328 2.808.219.752.515 1.352.888 1.8.373.448.808.768 1.304.96a4.327 4.327 0 0 0 1.576.288c.565 0 1.096-.096 1.592-.288a3.243 3.243 0 0 0 1.312-.96c.379-.448.677-1.048.896-1.8.219-.752.328-1.688.328-2.808 0-1.088-.11-2.003-.328-2.744-.219-.741-.517-1.336-.896-1.784a3.243 3.243 0 0 0-1.312-.96 4.371 4.371 0 0 0-1.592-.288c-.555 0-1.08.096-1.576.288-.496.192-.93.512-1.304.96-.373.448-.67 1.043-.888 1.784-.219.741-.328 1.656-.328 2.744zm2.272 0c0-.192.003-.424.008-.696.005-.272.024-.552.056-.84.032-.288.085-.573.16-.856a2.95 2.95 0 0 1 .312-.76 1.67 1.67 0 0 1 .512-.544c.208-.139.467-.208.776-.208.31 0 .57.07.784.208.213.139.39.32.528.544.139.224.243.477.312.76a7.8 7.8 0 0 1 .224 1.696 25.247 25.247 0 0 1-.024 1.856c-.021.453-.088.89-.2 1.312a2.754 2.754 0 0 1-.544 1.08c-.25.299-.61.448-1.08.448-.459 0-.81-.15-1.056-.448a2.815 2.815 0 0 1-.536-1.08 6.233 6.233 0 0 1-.2-1.312c-.021-.453-.032-.84-.032-1.16zm6.624 0c0 1.12.11 2.056.328 2.808.219.752.515 1.352.888 1.8.373.448.808.768 1.304.96a4.327 4.327 0 0 0 1.576.288c.565 0 1.096-.096 1.592-.288a3.243 3.243 0 0 0 1.312-.96c.379-.448.677-1.048.896-1.8.219-.752.328-1.688.328-2.808 0-1.088-.11-2.003-.328-2.744-.219-.741-.517-1.336-.896-1.784a3.243 3.243 0 0 0-1.312-.96 4.371 4.371 0 0 0-1.592-.288c-.555 0-1.08.096-1.576.288-.496.192-.93.512-1.304.96-.373.448-.67 1.043-.888 1.784-.219.741-.328 1.656-.328 2.744zm2.272 0c0-.192.003-.424.008-.696.005-.272.024-.552.056-.84.032-.288.085-.573.16-.856a2.95 2.95 0 0 1 .312-.76 1.67 1.67 0 0 1 .512-.544c.208-.139.467-.208.776-.208.31 0 .57.07.784.208.213.139.39.32.528.544.139.224.243.477.312.76a7.8 7.8 0 0 1 .224 1.696 25.247 25.247 0 0 1-.024 1.856c-.021.453-.088.89-.2 1.312a2.754 2.754 0 0 1-.544 1.08c-.25.299-.61.448-1.08.448-.459 0-.81-.15-1.056-.448a2.815 2.815 0 0 1-.536-1.08 6.233 6.233 0 0 1-.2-1.312c-.021-.453-.032-.84-.032-1.16z",
  palette: {
    path:
      "M21.925 3.275c11.278 5.97 11.278 16.586 8.625 17.912-1.99.664-3.317-2.653-3.317-2.653-.443-.885-1.327-.995-1.99 0-.74 1.109.39 4.12 1.027 5.814.125.332.23.614.3.82.663 1.99 0 4.312-1.991 5.307-1.99.995-7.855 1.4-12.973 0C7.304 29.298.492 24.807.033 16.544-.69 3.554 10.647-2.696 21.925 3.275zm-.696 5.021a2.654 2.654 0 1 1-5.307 0 2.654 2.654 0 0 1 5.307 0zM10.391 9.91a2.654 2.654 0 1 0 0-5.307 2.654 2.654 0 0 0 0 5.307zm-1.989 4.577a2.654 2.654 0 1 1-5.307 0 2.654 2.654 0 0 1 5.307 0zm2.213 10.018a2.654 2.654 0 1 0 0-5.307 2.654 2.654 0 0 0 0 5.307z",
    attrs: { fillRule: "evenodd" },
  },
  pencil:
    "M21.187 4.359L24.71.835c1.363-1.362 3.912-1.022 5.694.76 1.783 1.783 2.123 4.332.761 5.695l-3.523 3.523-6.455-6.454zM19.425 6.12L1.455 24.091C.091 25.453-.47 30.625.452 31.547c.922.922 6.094.361 7.456-1.001l17.97-17.971-6.454-6.455z",
  permissions_limited:
    "M0,16 C0,7.163444 7.163444,0 16,0 C24.836556,0 32,7.163444 32,16 C32,24.836556 24.836556,32 16,32 C7.163444,32 0,24.836556 0,16 Z M29,16 C29,8.82029825 23.1797017,3 16,3 C8.82029825,3 3,8.82029825 3,16 C3,23.1797017 8.82029825,29 16,29 C23.1797017,29 29,23.1797017 29,16 Z M16,5 C11.0100706,5.11743299 5.14533409,7.90852303 5,15.5 C4.85466591,23.091477 11.0100706,26.882567 16,27 L16,5 Z",
  person:
    "M16.068.005c5.181-.185 7.295 4.545 7.295 7.258s-1.34 6.71-3.607 8.77c-.5.456-.408 3.34.686 3.808 2.294.982 8.57 2.97 8.808 7.065.265 4.558-7.968 5.022-13.043 5.022-5.075 0-13.207-.62-13.207-4.45 0-1.776.178-2.944 3.106-4.92 2.927-1.978 5.16-2.462 5.645-2.763.486-.3 1.384-1.861.8-3.606 0 0-3.518-3.842-3.518-8.074 0-4.232 1.853-7.925 7.035-8.11z",
  pie:
    "M22.9192471,17.0666667 C22.9724214,16.7188743 23,16.3626578 23,16 C23,14.3667929 22.4406801,12.8642219 21.5031397,11.6733866 L28.0205298,5.44000778 C30.4977559,8.25762919 32,11.9533806 32,16 C32,16.3584305 31.988214,16.7141081 31.9650085,17.0666667 L22.9192471,17.0666667 Z M16,9 L16,-3.10862447e-15 C20.0533476,-3.55271368e-15 23.7546596,1.50724379 26.5740394,3.99183486 L20.2205338,10.4149697 C19.0471112,9.52684227 17.5850809,9 16,9 Z M13.8666667,9.33102327 C11.0439201,10.2332367 9,12.8779268 9,16 C9,19.8659932 12.1340068,23 16,23 C18.7129744,23 21.0654761,21.4566333 22.2274052,19.2 L31.679942,19.2 C30.197477,26.503169 23.7406653,32 16,32 C7.163444,32 -3.55271368e-15,24.836556 -3.55271368e-15,16 C-3.55271368e-15,7.88676941 6.03869982,1.18395273 13.8666667,0.140982757 L13.8666667,9.33102327 Z",
  pin:
    "M9.417 4.226A2.183 2.183 0 0 1 10.182 0h12.636a2.182 2.182 0 0 1 .765 4.226v9.003a2.183 2.183 0 0 1-.765 4.226H10.182a2.182 2.182 0 0 1-.765-4.226V4.226zm4.25 14.683h5.666L16.5 32l-2.833-13.09z",
  pinmap:
    "M13.4 18.987v8.746L15.533 32l2.134-4.25v-8.763a10.716 10.716 0 0 1-4.267 0zm2.133-1.92a8.533 8.533 0 1 0 0-17.067 8.533 8.533 0 0 0 0 17.067z",
  pivot_table: {
    path:
      "M9.846 0H0v9.846h9.846V0zM32 12.308H12.308V32H32V12.308zm-32 0h9.846V32H0V12.308zM32 0H12.308v9.846H32V0z",
    attrs: { fillRule: "evenodd" },
  },
  play:
    "M2 2.432v27.136a2 2 0 0 0 2.986 1.74L28.929 17.74a2 2 0 0 0 0-3.48L4.986.692A2 2 0 0 0 2 2.432z",
  popover:
    "M5 7.52564C5 6.42107 5.89543 5.52564 7 5.52564H12.7647L15.2632 2.80292C15.6595 2.37107 16.3405 2.37107 16.7368 2.80292L19.2353 5.52564H25C26.1046 5.52564 27 6.42107 27 7.52564V25.5C27 26.6046 26.1046 27.5 25 27.5H7C5.89543 27.5 5 26.6046 5 25.5V7.52564Z",
  popular:
    "M23.29 11.224l-7.067 7.067-2.658-2.752.007-.007-.386-.385-.126-.131-.003.002-1.789-1.79L.705 23.793A.994.994 0 0 0 .704 25.2l.896.897a1 1 0 0 0 1.408-.002l8.253-8.252 2.654 2.748.226-.218-.161.161 1.152 1.152c.64.64 1.668.636 2.304 0l8.158-8.159L32 19.933V5H17.067l6.223 6.224z",
  progress: {
    path:
      "M0 11.996A3.998 3.998 0 0 1 4.004 8h23.992A4 4 0 0 1 32 11.996v8.008A3.998 3.998 0 0 1 27.996 24H4.004A4 4 0 0 1 0 20.004v-8.008zM22 11h3.99A3.008 3.008 0 0 1 29 14v4c0 1.657-1.35 3-3.01 3H22V11z",
    attrs: { fillRule: "evenodd" },
  },
  pulse:
    "M16.9862306,27.387699 C17.4904976,29.2137955 20.0148505,29.3806482 20.7550803,27.6368095 L24.8588086,17.9692172 L31.7352165,17.9692172 L31.7352165,13.9692172 L23.5350474,13.9692172 C22.7324769,13.9692172 22.0076375,14.4489743 21.6940431,15.1877423 L19.314793,20.7927967 L14.8067319,4.4678059 C14.3010535,2.63659841 11.7668377,2.47581319 11.033781,4.22842821 L6.99549907,13.8832799 L0,13.8832799 L0,17.8832799 L8.32686781,17.8832799 C9.13327931,17.8832799 9.86080237,17.3989791 10.1719732,16.655022 L12.491241,11.1100437 L16.9862306,27.387699 Z",
  recents:
    "M32 16c0 8.837-7.163 16-16 16S0 24.837 0 16 7.163 0 16 0s16 7.163 16 16zM9.553 22.447a1.778 1.778 0 0 1 0-2.514l4.67-4.67V6.452a1.778 1.778 0 1 1 3.555 0V16l-.52 1.257-5.191 5.19a1.778 1.778 0 0 1-2.514 0z",
  share:
    "M29.5 22.725c-1.46 0-2.5-1.183-2.5-2.643V9L5 31.226c-1.032 1.032-2.968 1.032-4 0S-.258 28.52.774 27.488L23 5H12c-1.46 0-2.725-1.04-2.725-2.5S10.54 0 12 0h16.5c2 0 3.5 1.5 3.5 4v16.082c0 1.46-1.04 2.643-2.5 2.643z",
  sql: {
    path:
      "M4,0 L28,0 C30.209139,-4.05812251e-16 32,1.790861 32,4 L32,28 C32,30.209139 30.209139,32 28,32 L4,32 C1.790861,32 2.705415e-16,30.209139 0,28 L0,4 L0,4 C-2.705415e-16,1.790861 1.790861,4.05812251e-16 4,0 L4,0 Z M6,6 C4.8954305,6 4,6.8954305 4,8 L4,26 C4,27.1045695 4.8954305,28 6,28 L26,28 C27.1045695,28 28,27.1045695 28,26 L28,8 C28,6.8954305 27.1045695,6 26,6 L6,6 Z M14,20 L25,20 L25,24 L14,24 L14,20 Z M14,13.5 L8,17 L8,10 L14,13.5 Z",
    attrs: { fillRule: "evenodd" },
  },
  straight: "M2.1 27.101L0 23.516 29.9 6 32 9.585z",
  stepped: "M13.946 17.892v8H1V22h9.054v-8h9V6H32v3.892h-9.054v8z",
  sort:
    "M14.615.683c.765-.926 2.002-.93 2.77 0L26.39 11.59c.765.927.419 1.678-.788 1.678H6.398c-1.2 0-1.557-.747-.788-1.678L14.615.683zm2.472 30.774c-.6.727-1.578.721-2.174 0l-9.602-11.63c-.6-.727-.303-1.316.645-1.316h20.088c.956 0 1.24.595.645 1.316l-9.602 11.63z",
  sum:
    "M3 27.41l1.984 4.422L27.895 32l.04-5.33-17.086-.125 8.296-9.457-.08-3.602L11.25 5.33H27.43V0H5.003L3.08 4.51l10.448 10.9z",
  sync:
    "M19.506 8.633a9.3 9.3 0 0 0-7.864-.534C6.81 9.966 4.395 15.422 6.251 20.285c1.855 4.863 7.276 7.292 12.11 5.425a9.332 9.332 0 0 0 3.72-2.622l4.746 3.101a14.935 14.935 0 0 1-6.451 4.805C12.643 33.98 3.968 30.094 1 22.313c-2.968-7.781.894-16.51 8.627-19.497 4.395-1.698 9.096-1.175 12.879 1.022L24.907 0 31 12.733H16.94l2.566-4.1z",
  question:
    "M16,32 C24.836556,32 32,24.836556 32,16 C32,7.163444 24.836556,0 16,0 C7.163444,0 0,7.163444 0,16 C0,24.836556 7.163444,32 16,32 L16,32 Z M16,29.0909091 C8.77009055,29.0909091 2.90909091,23.2299095 2.90909091,16 C2.90909091,8.77009055 8.77009055,2.90909091 16,2.90909091 C23.2299095,2.90909091 29.0909091,8.77009055 29.0909091,16 C29.0909091,23.2299095 23.2299095,29.0909091 16,29.0909091 Z M12,9.56020942 C12.2727286,9.34380346 12.5694087,9.1413622 12.8900491,8.95287958 C13.2106896,8.76439696 13.5552807,8.59860455 13.9238329,8.45549738 C14.2923851,8.31239021 14.6885728,8.20069848 15.1124079,8.12041885 C15.5362429,8.04013921 15.9950835,8 16.4889435,8 C17.1818216,8 17.8065083,8.08725916 18.3630221,8.2617801 C18.919536,8.43630105 19.3931184,8.68586225 19.7837838,9.0104712 C20.1744491,9.33508016 20.4748147,9.7260012 20.6848894,10.1832461 C20.8949642,10.6404909 21,11.1483393 21,11.7068063 C21,12.2373499 20.9226052,12.6963331 20.7678133,13.0837696 C20.6130213,13.4712061 20.4176916,13.8080265 20.1818182,14.0942408 C19.9459448,14.3804552 19.6861194,14.6282712 19.4023342,14.8376963 C19.1185489,15.0471215 18.8495099,15.2408368 18.5952088,15.4188482 C18.3409078,15.5968595 18.1197798,15.773123 17.9318182,15.947644 C17.7438566,16.1221649 17.6240789,16.3176254 17.5724816,16.5340314 L17.2628993,18 L14.9189189,18 L14.6756757,16.3141361 C14.6167073,15.9720751 14.653562,15.6736487 14.7862408,15.4188482 C14.9189196,15.1640476 15.1013502,14.9336834 15.3335381,14.7277487 C15.565726,14.521814 15.8255514,14.3263535 16.1130221,14.1413613 C16.4004928,13.9563691 16.6695319,13.7574182 16.9201474,13.5445026 C17.1707629,13.3315871 17.3826773,13.0942421 17.5558968,12.8324607 C17.7291163,12.5706793 17.8157248,12.2582915 17.8157248,11.895288 C17.8157248,11.4764377 17.6701489,11.1431077 17.3789926,10.895288 C17.0878364,10.6474682 16.6879632,10.5235602 16.1793612,10.5235602 C15.7886958,10.5235602 15.462532,10.5619542 15.20086,10.6387435 C14.9391879,10.7155327 14.7143744,10.8010466 14.5264128,10.895288 C14.3384511,10.9895293 14.1744479,11.0750432 14.034398,11.1518325 C13.8943482,11.2286217 13.7543005,11.2670157 13.6142506,11.2670157 C13.2972957,11.2670157 13.0614258,11.1378721 12.9066339,10.8795812 L12,9.56020942 Z M14,22 C14,21.7192968 14.0511359,21.4580909 14.1534091,21.2163743 C14.2556823,20.9746577 14.3958324,20.7641335 14.5738636,20.5847953 C14.7518948,20.4054572 14.96212,20.2631584 15.2045455,20.1578947 C15.4469709,20.0526311 15.7121198,20 16,20 C16.2803044,20 16.5416655,20.0526311 16.7840909,20.1578947 C17.0265164,20.2631584 17.2386355,20.4054572 17.4204545,20.5847953 C17.6022736,20.7641335 17.7443177,20.9746577 17.8465909,21.2163743 C17.9488641,21.4580909 18,21.7192968 18,22 C18,22.2807032 17.9488641,22.5438584 17.8465909,22.7894737 C17.7443177,23.0350889 17.6022736,23.2475625 17.4204545,23.4269006 C17.2386355,23.6062387 17.0265164,23.7465882 16.7840909,23.8479532 C16.5416655,23.9493182 16.2803044,24 16,24 C15.7121198,24 15.4469709,23.9493182 15.2045455,23.8479532 C14.96212,23.7465882 14.7518948,23.6062387 14.5738636,23.4269006 C14.3958324,23.2475625 14.2556823,23.0350889 14.1534091,22.7894737 C14.0511359,22.5438584 14,22.2807032 14,22 Z",
  return:
    "M15.3040432,11.8500793 C22.1434689,13.0450349 27.291257,18.2496116 27.291257,24.4890512 C27.291257,25.7084278 27.0946472,26.8882798 26.7272246,28.0064033 L26.7272246,28.0064033 C25.214579,22.4825472 20.8068367,18.2141694 15.3040432,17.0604596 L15.3040432,25.1841972 L4.70874296,14.5888969 L15.3040432,3.99359668 L15.3040432,3.99359668 L15.3040432,11.8500793 Z",
  reference:
    "M32 25h-5V7a2 2 0 0 0-2-2H7a2 2 0 1 0 0 4h16v23H4a4 4 0 0 1-4-4V6a6 6 0 0 1 6-6h22a4 4 0 0 1 4 4v21z",
  refresh:
    "M19.506 8.633a9.3 9.3 0 0 0-7.864-.534C6.81 9.966 4.395 15.422 6.251 20.285c1.855 4.863 7.276 7.292 12.11 5.425a9.332 9.332 0 0 0 3.72-2.622l4.746 3.101a14.935 14.935 0 0 1-6.451 4.805C12.643 33.98 3.968 30.094 1 22.313c-2.968-7.781.894-16.51 8.627-19.497 4.395-1.698 9.096-1.175 12.879 1.022L24.907 0 31 12.733H16.94l2.566-4.1z",
  ruler:
    "M0.595961814,24.9588734 C-0.196619577,24.166292 -0.200005392,22.8846495 0.593926984,22.0907171 L22.0908075,0.593836573 C22.8822651,-0.197621013 24.1641442,-0.198948234 24.9589638,0.595871404 L31.4040382,7.04094576 C32.1966196,7.83352715 32.2000054,9.11516967 31.406073,9.90910205 L9.90919246,31.4059826 C9.11773487,32.1974402 7.83585581,32.1987674 7.04103617,31.4039478 L0.595961814,24.9588734 Z M17.8319792,7.8001489 L16.3988585,9.23326963 L18.548673,11.3830842 C18.9443414,11.7787526 18.9470387,12.4175604 18.5485351,12.816064 C18.1527906,13.2118086 17.5140271,13.2146738 17.1155553,12.816202 L14.9657407,10.6663874 L13.5326229,12.0995052 L15.6824375,14.2493198 C16.0781059,14.6449881 16.0808032,15.283796 15.6822996,15.6822996 C15.286555,16.0780441 14.6477916,16.0809094 14.2493198,15.6824375 L12.0995052,13.5326229 L10.6663845,14.9657436 C10.6670858,14.9664411 10.6677865,14.9671398 10.6684864,14.9678397 L14.2470828,18.5464361 C14.6439866,18.9433399 14.6476854,19.5831493 14.2491818,19.9816529 C13.8534373,20.3773974 13.2188552,20.384444 12.813965,19.9795538 L9.23536867,16.4009575 C9.23466875,16.4002576 9.23397006,16.3995569 9.2332726,16.3988555 L7.80015186,17.8319762 L9.94996646,19.9817908 C10.3456348,20.3774592 10.3483321,21.016267 9.94982851,21.4147706 C9.55408397,21.8105152 8.91532053,21.8133804 8.51684869,21.4149086 L6.3670341,19.265094 L4.93391633,20.6982118 L7.08373093,22.8480263 C7.47939928,23.2436947 7.48209658,23.8825026 7.08359298,24.2810062 C6.68784844,24.6767507 6.049085,24.6796159 5.65061316,24.2811441 L3.50079857,22.1313295 L2.02673458,23.6053935 L8.47576453,30.0544235 L30.0544235,8.47576453 L23.6053935,2.02673458 L22.1313295,3.50079857 L24.2811441,5.65061316 C24.6768125,6.04628152 24.6795098,6.68508938 24.2810062,7.08359298 C23.8852616,7.47933752 23.2464982,7.48220276 22.8480263,7.08373093 L20.6982118,4.93391633 L19.2650911,6.36703697 C19.2657924,6.36773446 19.2664931,6.36843318 19.267193,6.36913314 L22.8457894,9.94772948 C23.2426932,10.3446333 23.246392,10.9844427 22.8478884,11.3829463 C22.4521439,11.7786908 21.8175617,11.7857374 21.4126716,11.3808472 L17.8340753,7.8022509 C17.8333753,7.80155099 17.8326767,7.80085032 17.8319792,7.8001489 Z",
  search:
    "M22.805 25.734c-5.582 4.178-13.543 3.718-18.632-1.37-5.58-5.581-5.595-14.615-.031-20.179 5.563-5.563 14.597-5.55 20.178.031 5.068 5.068 5.545 12.985 1.422 18.563l5.661 5.661a2.08 2.08 0 0 1 .003 2.949 2.085 2.085 0 0 1-2.95-.003l-5.651-5.652zm-1.486-4.371c3.895-3.895 3.885-10.218-.021-14.125-3.906-3.906-10.23-3.916-14.125-.021-3.894 3.894-3.885 10.218.022 14.124 3.906 3.907 10.23 3.916 14.124.022z",
  segment:
    "M2.99631547,14.0294075 L2.99631579,1.99517286 C2.99631582,0.893269315 3.89614282,0 4.98985651,0 L30.0064593,0 C31.1074614,0 32,0.895880847 32,2.00761243 L32,26.8688779 C32,27.9776516 31.1071386,28.8764903 30.0003242,28.8764903 L17.7266598,28.8764903 L17.7266594,14.0294075 L2.99631547,14.0294075 Z M-7.10651809e-15,16.9955967 L-7.10651809e-15,30.0075311 C-7.10651809e-15,31.1079413 0.900469916,32 2.00155906,32 L14.3949712,32 L14.3949712,16.9955967 L-7.10651809e-15,16.9955967 Z",
  slack_colorized: {
    img: "app/assets/img/slack.png",
  },
  slack:
    "M20.209 0a3.374 3.374 0 0 0-3.374 3.374v8.417a3.374 3.374 0 1 0 6.748 0V3.374A3.374 3.374 0 0 0 20.209 0zm0 16.835a3.374 3.374 0 1 0 0 6.748h8.417a3.374 3.374 0 1 0 0-6.748H20.21zM0 11.79a3.374 3.374 0 0 1 3.374-3.374h8.417a3.374 3.374 0 1 1 0 6.748H3.374A3.374 3.374 0 0 1 0 11.791zM11.791 0a3.374 3.374 0 1 0 0 6.748h3.374V3.374A3.374 3.374 0 0 0 11.791 0zm13.461 11.791a3.374 3.374 0 1 1 3.374 3.374h-3.374v-3.374zM3.374 16.835a3.374 3.374 0 1 0 3.374 3.374v-3.374H3.374zm13.46 8.417h3.375a3.374 3.374 0 1 1-3.374 3.374v-3.374zm-5.043-8.417a3.374 3.374 0 0 0-3.374 3.374v8.417a3.374 3.374 0 1 0 6.748 0V20.21a3.374 3.374 0 0 0-3.374-3.374z",
  smartscalar:
    "M9.806 9.347v13.016h-2.79V9.593L3.502 14.12a1.405 1.405 0 0 1-1.957.254 1.372 1.372 0 0 1-.256-1.937L7.418 4.54a1.404 1.404 0 0 1 2.219.008l6.08 7.953a1.372 1.372 0 0 1-.27 1.935c-.615.46-1.49.34-1.955-.268l-3.686-4.82zM24.806 23.016V13h-2.79v9.77l-3.514-4.527a1.405 1.405 0 0 0-1.957-.254 1.372 1.372 0 0 0-.256 1.937l6.129 7.897c.56.723 1.663.72 2.219-.008l6.08-7.953a1.372 1.372 0 0 0-.27-1.935 1.405 1.405 0 0 0-1.955.268l-3.686 4.82z",
  snippet: {
    path: "M1,2H8M1,5H9M1,8H6",
    attrs: {
      viewBox: "0 0 10 10",
      style: { strokeWidth: 2, stroke: "currentcolor", strokeLinecap: "round" },
    },
  },
  star: "M16 0 L21 11 L32 12 L23 19 L26 31 L16 25 L6 31 L9 19 L0 12 L11 11",
  star_outline:
    "M16 21.935l5.967 3.14-1.14-6.653 4.828-4.712-6.671-.97L16 6.685l-2.984 6.053-6.67.971 4.827 4.712-1.14 6.654L16 21.935zm-9.892 8.547l1.89-11.029L0 11.647l11.053-1.609L16 0l4.947 10.038L32 11.647l-7.997 7.806 1.889 11.03L16 25.274l-9.892 5.207z",
  string: {
    path:
      "M14.022,18 L11.533,18 C11.2543319,18 11.0247509,17.935084 10.84425,17.80525 C10.6637491,17.675416 10.538667,17.5091677 10.469,17.3065 L9.652,14.8935 L4.389,14.8935 L3.572,17.3065 C3.50866635,17.4838342 3.38516758,17.6437493 3.2015,17.78625 C3.01783241,17.9287507 2.79300133,18 2.527,18 L0.019,18 L5.377,4.1585 L8.664,4.1585 L14.022,18 Z M5.13,12.7085 L8.911,12.7085 L7.638,8.918 C7.55566626,8.67733213 7.45908389,8.3939183 7.34825,8.06775 C7.23741611,7.7415817 7.12816721,7.3885019 7.0205,7.0085 C6.91916616,7.39483527 6.8146672,7.75266502 6.707,8.082 C6.5993328,8.41133498 6.49800047,8.69633213 6.403,8.937 L5.13,12.7085 Z M21.945,18 C21.6663319,18 21.4557507,17.9620004 21.31325,17.886 C21.1707493,17.8099996 21.0520005,17.6516679 20.957,17.411 L20.748,16.8695 C20.5009988,17.078501 20.2635011,17.2621659 20.0355,17.4205 C19.8074989,17.5788341 19.5715846,17.7134161 19.32775,17.82425 C19.0839154,17.9350839 18.8242514,18.0174164 18.54875,18.07125 C18.2732486,18.1250836 17.9676683,18.152 17.632,18.152 C17.1823311,18.152 16.7738352,18.0934173 16.4065,17.97625 C16.0391648,17.8590827 15.7272513,17.6865011 15.47075,17.4585 C15.2142487,17.2304989 15.016334,16.947085 14.877,16.60825 C14.737666,16.269415 14.668,15.8783355 14.668,15.435 C14.668,15.0866649 14.7566658,14.7288352 14.934,14.3615 C15.1113342,13.9941648 15.4184978,13.6600848 15.8555,13.35925 C16.2925022,13.0584152 16.8814963,12.8066677 17.6225,12.604 C18.3635037,12.4013323 19.297661,12.2873335 20.425,12.262 L20.425,11.844 C20.425,11.2676638 20.3062512,10.8512513 20.06875,10.59475 C19.8312488,10.3382487 19.4940022,10.21 19.057,10.21 C18.7086649,10.21 18.4236678,10.2479996 18.202,10.324 C17.9803322,10.4000004 17.7824175,10.4854995 17.60825,10.5805 C17.4340825,10.6755005 17.2646675,10.7609996 17.1,10.837 C16.9353325,10.9130004 16.7390011,10.951 16.511,10.951 C16.3083323,10.951 16.1357507,10.9019172 15.99325,10.80375 C15.8507493,10.7055828 15.7383337,10.5836674 15.656,10.438 L15.124,9.5165 C15.7193363,8.99083071 16.3795797,8.59975128 17.10475,8.34325 C17.8299203,8.08674872 18.6073292,7.9585 19.437,7.9585 C20.0323363,7.9585 20.5690809,8.05508237 21.04725,8.24825 C21.5254191,8.44141763 21.9307483,8.71058161 22.26325,9.05575 C22.5957517,9.40091839 22.8506658,9.81099763 23.028,10.286 C23.2053342,10.7610024 23.294,11.2803305 23.294,11.844 L23.294,18 L21.945,18 Z M18.563,16.2045 C18.9430019,16.2045 19.2754986,16.1380007 19.5605,16.005 C19.8455014,15.8719993 20.1336652,15.6566682 20.425,15.359 L20.425,13.991 C19.8359971,14.0163335 19.3515019,14.0669996 18.9715,14.143 C18.5914981,14.2190004 18.2906678,14.3139994 18.069,14.428 C17.8473322,14.5420006 17.6937504,14.6718326 17.60825,14.8175 C17.5227496,14.9631674 17.48,15.1214991 17.48,15.2925 C17.48,15.6281683 17.5718324,15.8640827 17.7555,16.00025 C17.9391676,16.1364173 18.2083316,16.2045 18.563,16.2045 L18.563,16.2045 Z",
    attrs: { viewBox: "0 0 24 24" },
  },
  sun:
    "M18.2857143,27.1999586 L18.2857143,29.7130168 C18.2857143,30.9760827 17.2711661,32 16,32 C14.7376349,32 13.7142857,30.9797942 13.7142857,29.7130168 L13.7142857,27.1999586 C14.4528227,27.3498737 15.2172209,27.4285714 16,27.4285714 C16.7827791,27.4285714 17.5471773,27.3498737 18.2857143,27.1999586 Z M13.7142857,4.80004141 L13.7142857,2.28698322 C13.7142857,1.02391726 14.7288339,0 16,0 C17.2623651,0 18.2857143,1.02020582 18.2857143,2.28698322 L18.2857143,4.80004141 C17.5471773,4.65012631 16.7827791,4.57142857 16,4.57142857 C15.2172209,4.57142857 14.4528227,4.65012631 13.7142857,4.80004141 Z M10.5518048,26.0488463 L8.93640145,27.9740091 C8.1245183,28.9415738 6.68916799,29.0738009 5.71539825,28.2567111 C4.74837044,27.4452784 4.62021518,26.0059593 5.43448399,25.0355515 L7.05102836,23.1090289 C8.00526005,24.3086326 9.1956215,25.3120077 10.5518048,26.0488463 Z M21.4481952,5.95115366 L23.0635986,4.02599087 C23.8754817,3.05842622 25.310832,2.92619908 26.2846018,3.74328891 C27.2516296,4.55472158 27.3797848,5.99404073 26.565516,6.96444852 L24.9489716,8.89097108 C23.9947399,7.69136735 22.8043785,6.68799226 21.4481952,5.95115366 Z M7.05102836,8.89097108 L5.43448399,6.96444852 C4.62260085,5.99688386 4.7416285,4.56037874 5.71539825,3.74328891 C6.68242605,2.93185624 8.12213263,3.05558308 8.93640145,4.02599087 L10.5518048,5.95115366 C9.1956215,6.68799226 8.00526005,7.69136735 7.05102836,8.89097108 Z M24.9489716,23.1090289 L26.565516,25.0355515 C27.3773992,26.0031161 27.2583715,27.4396213 26.2846018,28.2567111 C25.317574,29.0681438 23.8778674,28.9444169 23.0635986,27.9740091 L21.4481952,26.0488463 C22.8043785,25.3120077 23.9947399,24.3086326 24.9489716,23.1090289 Z M27.1999586,13.7142857 L29.7130168,13.7142857 C30.9760827,13.7142857 32,14.7288339 32,16 C32,17.2623651 30.9797942,18.2857143 29.7130168,18.2857143 L27.1999586,18.2857143 C27.3498737,17.5471773 27.4285714,16.7827791 27.4285714,16 C27.4285714,15.2172209 27.3498737,14.4528227 27.1999586,13.7142857 Z M4.80004141,18.2857143 L2.28698322,18.2857143 C1.02391726,18.2857143 2.7533531e-14,17.2711661 2.84217094e-14,16 C2.84217094e-14,14.7376349 1.02020582,13.7142857 2.28698322,13.7142857 L4.80004141,13.7142857 C4.65012631,14.4528227 4.57142857,15.2172209 4.57142857,16 C4.57142857,16.7827791 4.65012631,17.5471773 4.80004141,18.2857143 Z M16,22.8571429 C19.7870954,22.8571429 22.8571429,19.7870954 22.8571429,16 C22.8571429,12.2129046 19.7870954,9.14285714 16,9.14285714 C12.2129046,9.14285714 9.14285714,12.2129046 9.14285714,16 C9.14285714,19.7870954 12.2129046,22.8571429 16,22.8571429 Z",
  table:
    "M11.077 11.077h9.846v9.846h-9.846v-9.846zm11.077 11.077H32V32h-9.846v-9.846zm-11.077 0h9.846V32h-9.846v-9.846zM0 22.154h9.846V32H0v-9.846zM0 0h9.846v9.846H0V0zm0 11.077h9.846v9.846H0v-9.846zM22.154 0H32v9.846h-9.846V0zm0 11.077H32v9.846h-9.846v-9.846zM11.077 0h9.846v9.846h-9.846V0z",
  table2:
    "M1.6 0h28.8A1.6 1.6 0 0 1 32 1.6v28.8a1.6 1.6 0 0 1-1.6 1.6H1.6A1.6 1.6 0 0 1 0 30.4V1.6A1.6 1.6 0 0 1 1.6 0zm1.6 3.2v6.4h6.4V3.2H3.2zm9.6 0v6.4h16V3.2h-16zm-9.6 9.6v6.4h6.4v-6.4H3.2zm9.6 0v6.4h16v-6.4h-16zm-9.6 9.6v6.4h6.4v-6.4H3.2zm9.6 0v6.4h16v-6.4h-16z",
  table_spaced:
    "M0 0h7.784v7.784H0V0zm12.108 0h7.784v7.784h-7.784V0zm12.108 0H32v7.784h-7.784V0zM0 12.108h7.784v7.784H0v-7.784zm12.108 0h7.784v7.784h-7.784v-7.784zm12.108 0H32v7.784h-7.784v-7.784zM0 24.216h7.784V32H0v-7.784zm12.108 0h7.784V32h-7.784v-7.784zm12.108 0H32V32h-7.784v-7.784z",
  trash:
    "M4.31904507,29.7285487 C4.45843264,30.9830366 5.59537721,32 6.85726914,32 L20.5713023,32 C21.8337371,32 22.9701016,30.9833707 23.1095264,29.7285487 L25.1428571,11.4285714 L2.28571429,11.4285714 L4.31904507,29.7285487 L4.31904507,29.7285487 Z M6.85714286,4.57142857 L8.57142857,0 L18.8571429,0 L20.5714286,4.57142857 L25.1428571,4.57142857 C27.4285714,4.57142857 27.4285714,9.14285714 27.4285714,9.14285714 L13.7142857,9.14285714 L-1.0658141e-14,9.14285714 C-1.0658141e-14,9.14285714 -1.0658141e-14,4.57142857 2.28571429,4.57142857 L6.85714286,4.57142857 L6.85714286,4.57142857 Z M9.14285714,4.57142857 L18.2857143,4.57142857 L17.1428571,2.28571429 L10.2857143,2.28571429 L9.14285714,4.57142857 L9.14285714,4.57142857 Z",
  triangle_left: "M21,0 L5,16 L21,32 L21,5.47117907e-13 L21,0 Z",
  triangle_right: "M9,0 L25,16 L9,32 L9,5.47117907e-13 L9,0 Z",
  unarchive:
    "M18,7.95916837 L22.98085,7.97386236 L15.9779702,-0.00230793315 L9.02202984,7.93268248 L14,7.94736798 L14,22.8635899 L18,22.8635899 L18,7.95916837 Z M7,12.1176568 L0,12.1176568 L0,17.0882426 L3,17.0882426 L3,32 L29,32 L29,17.0882426 L32,17.0882426 L32,12.1176568 L25,12.1176568 L25,27.8341757 L7,27.8341757 L7,12.1176568 Z",
  unknown:
    "M16.5,26.5 C22.0228475,26.5 26.5,22.0228475 26.5,16.5 C26.5,10.9771525 22.0228475,6.5 16.5,6.5 C10.9771525,6.5 6.5,10.9771525 6.5,16.5 C6.5,22.0228475 10.9771525,26.5 16.5,26.5 L16.5,26.5 Z M16.5,23.5 C12.6340068,23.5 9.5,20.3659932 9.5,16.5 C9.5,12.6340068 12.6340068,9.5 16.5,9.5 C20.3659932,9.5 23.5,12.6340068 23.5,16.5 C23.5,20.3659932 20.3659932,23.5 16.5,23.5 L16.5,23.5 Z",
  variable:
    "M32,3.85760518 C32,5.35923081 31.5210404,6.55447236 30.5631068,7.4433657 C29.6051732,8.33225903 28.4358214,8.77669903 27.0550162,8.77669903 C26.2265331,8.77669903 25.4110072,8.67314019 24.6084142,8.46601942 C23.8058212,8.25889864 23.111114,8.05178097 22.5242718,7.84466019 C22.2481108,8.03452091 21.8425054,8.44875625 21.3074434,9.08737864 C20.7723814,9.72600104 20.1682882,10.5026923 19.4951456,11.4174757 C20.116508,14.0582656 20.6170423,15.9352695 20.9967638,17.0485437 C21.3764852,18.1618179 21.7389411,19.2880202 22.0841424,20.4271845 C22.3775635,21.3419679 22.8090586,22.0582498 23.3786408,22.5760518 C23.9482229,23.0938537 24.8457328,23.3527508 26.0711974,23.3527508 C26.5199591,23.3527508 27.0809028,23.2664518 27.7540453,23.0938511 C28.4271878,22.9212505 28.9795016,22.7486524 29.4110032,22.5760518 L28.8414239,24.9061489 C27.1326775,25.6310716 25.6397043,26.1574957 24.3624595,26.4854369 C23.0852148,26.8133781 21.9460676,26.9773463 20.9449838,26.9773463 C20.2200611,26.9773463 19.5037792,26.9083071 18.7961165,26.7702265 C18.0884539,26.632146 17.4412111,26.3818788 16.8543689,26.0194175 C16.2157465,25.6396961 15.6763776,25.1650514 15.236246,24.5954693 C14.7961143,24.0258871 14.4207135,23.2319361 14.1100324,22.2135922 C13.9029116,21.5749698 13.7130537,20.850058 13.5404531,20.038835 C13.3678524,19.2276119 13.1952544,18.51133 13.0226537,17.8899676 C12.5221118,18.6321504 12.1596559,19.1844642 11.9352751,19.5469256 C11.7108942,19.9093869 11.3829579,20.4185512 10.9514563,21.0744337 C9.5879112,23.1629015 8.4056145,24.6515597 7.40453074,25.5404531 C6.40344699,26.4293464 5.20389049,26.8737864 3.80582524,26.8737864 C2.75296129,26.8737864 1.85545139,26.5199604 1.11326861,25.8122977 C0.371085825,25.1046351 0,24.1812355 0,23.0420712 C0,21.5059254 0.478959612,20.2934241 1.4368932,19.4045307 C2.3948268,18.5156374 3.56417864,18.0711974 4.94498382,18.0711974 C5.77346693,18.0711974 6.56741799,18.1704413 7.32686084,18.368932 C8.08630369,18.5674228 8.80258563,18.7874853 9.47572816,19.0291262 C9.73462913,18.8220054 10.1359196,18.4164 10.6796117,17.8122977 C11.2233037,17.2081955 11.814452,16.4573939 12.4530744,15.5598706 C11.8834923,13.2470219 11.4174775,11.5037815 11.0550162,10.3300971 C10.6925548,9.15641269 10.321469,7.99137579 9.94174757,6.83495146 C9.63106641,5.90290796 9.18231146,5.18231107 8.59546926,4.67313916 C8.00862706,4.16396725 7.12837696,3.90938511 5.95469256,3.90938511 C5.43689061,3.90938511 4.85868712,3.99999909 4.22006472,4.18122977 C3.58144233,4.36246045 3.04638835,4.53074356 2.61488673,4.68608414 L3.18446602,2.35598706 C4.73787184,1.66558447 6.20927029,1.14779029 7.5987055,0.802588997 C8.98814071,0.457387702 10.1488627,0.284789644 11.0809061,0.284789644 C11.9266493,0.284789644 12.6515612,0.345198964 13.2556634,0.466019417 C13.8597657,0.586839871 14.4983785,0.845736958 15.171521,1.24271845 C15.7928834,1.62243987 16.3322523,2.10139948 16.789644,2.67961165 C17.2470357,3.25782382 17.6224365,4.04745994 17.9158576,5.04854369 C18.1229784,5.73894628 18.3128362,6.45522822 18.4854369,7.197411 C18.6580375,7.93959379 18.8047459,8.5782066 18.9255663,9.11326861 C19.2880277,8.56094654 19.6634285,7.99137294 20.0517799,7.40453074 C20.4401314,6.81768854 20.7723827,6.29989437 21.0485437,5.85113269 C22.3775687,3.76266485 23.5684953,2.2653767 24.6213592,1.3592233 C25.6742232,0.453069903 26.8651498,0 28.1941748,0 C29.2815588,0 30.1876986,0.358140971 30.9126214,1.07443366 C31.6375441,1.79072634 32,2.71844091 32,3.85760518 L32,3.85760518 Z",
  view_archive: {
    path:
      "M2.783 12.8h26.434V29H2.783V12.8zm6.956 3.4h12.522v2.6H9.739v-2.6zM0 4h32v6.4H0V4z",
    attrs: { fillRule: "evenodd" },
  },
  warning: {
    path:
      "M12.3069589,4.52260192 C14.3462632,1.2440969 17.653446,1.24541073 19.691933,4.52260192 L31.2249413,23.0637415 C33.2642456,26.3422466 31.7889628,29 27.9115531,29 L4.08733885,29 C0.218100769,29 -1.26453645,26.3409327 0.77395061,23.0637415 L12.3069589,4.52260192 Z M18.0499318,23.0163223 C18.0499772,23.0222378 18.05,23.0281606 18.05,23.0340907 C18.05,23.3266209 17.9947172,23.6030345 17.8840476,23.8612637 C17.7737568,24.1186089 17.6195847,24.3426723 17.4224081,24.5316332 C17.2266259,24.7192578 16.998292,24.8660439 16.7389806,24.9713892 C16.4782454,25.0773129 16.1979962,25.1301134 15.9,25.1301134 C15.5950083,25.1301134 15.3111795,25.0774024 15.0502239,24.9713892 C14.7901813,24.8657469 14.5629613,24.7183609 14.3703047,24.5298034 C14.177545,24.3411449 14.0258626,24.1177208 13.9159524,23.8612637 C13.8052827,23.6030345 13.75,23.3266209 13.75,23.0340907 C13.75,22.7411889 13.8054281,22.4661013 13.9165299,22.2109786 C14.0264627,21.9585404 14.1779817,21.7374046 14.3703047,21.5491736 C14.5621821,21.3613786 14.7883231,21.2126553 15.047143,21.1034656 C15.3089445,20.9930181 15.593871,20.938068 15.9,20.938068 C16.1991423,20.938068 16.4804862,20.9931136 16.7420615,21.1034656 C17.0001525,21.2123478 17.2274115,21.360472 17.4224081,21.5473437 C17.6191428,21.7358811 17.7731504,21.957652 17.88347,22.2109786 C17.9124619,22.2775526 17.9376628,22.3454862 17.9590769,22.414741 C18.0181943,22.5998533 18.05,22.7963729 18.05,23 C18.05,23.0054459 18.0499772,23.0108867 18.0499318,23.0163223 L18.0499318,23.0163223 Z M17.7477272,14.1749999 L17.7477272,8.75 L14.1170454,8.75 L14.1170454,14.1749999 C14.1170454,14.8471841 14.1572355,15.5139742 14.2376219,16.1753351 C14.3174838,16.8323805 14.4227217,17.5019113 14.5533248,18.1839498 L14.5921937,18.3869317 L17.272579,18.3869317 L17.3114479,18.1839498 C17.442051,17.5019113 17.5472889,16.8323805 17.6271507,16.1753351 C17.7075371,15.5139742 17.7477272,14.8471841 17.7477272,14.1749999 Z",
    attrs: { fillRule: "evenodd" },
  },
  waterfall: {
    path: "M12 0h8v13h-8V0zM0 13h8v19H0V13zM32 0h-8v21h8V0z",
    attrs: { fillRule: "evenodd" },
  },
  zoom_in:
    "M12.416 12.454V8.37h3.256v4.083h4.07v3.266h-4.07v4.083h-3.256V15.72h-4.07v-3.266h4.07zm10.389 13.28c-5.582 4.178-13.543 3.718-18.632-1.37-5.58-5.581-5.595-14.615-.031-20.179 5.563-5.563 14.597-5.55 20.178.031 5.068 5.068 5.545 12.985 1.422 18.563l5.661 5.661a2.08 2.08 0 0 1 .003 2.949 2.085 2.085 0 0 1-2.95-.003l-5.651-5.652zm-1.486-4.371c3.895-3.895 3.885-10.218-.021-14.125-3.906-3.906-10.23-3.916-14.125-.021-3.894 3.894-3.885 10.218.022 14.124 3.906 3.907 10.23 3.916 14.124.022z",
  xlsx:
    "M28 10.105v18.728A3.166 3.166 0 0 1 24.834 32H6.166A3.163 3.163 0 0 1 3 28.844V3.156A3.163 3.163 0 0 1 6.16 0h13.553V10.105H28zm-.215-1.684h-6.4V.311l6.4 8.11zM9.446 25h2.427l2.796-3.37h.055L16.207 25h2.256l-2.18-4.888 4.32-4.976h-2.468l-2.769 3.343h-.054l-1.477-3.343h-2.256l2.18 4.874L9.447 25z",
  zoom_out:
    "M22.8048272,25.7342559 C17.2227958,29.9120922 9.26170192,29.4524812 4.17264358,24.3634229 C-1.40785877,18.7829205 -1.42162182,9.74890155 4.14190296,4.18537677 C9.70542774,-1.37814801 18.7394467,-1.36438497 24.319949,4.21611739 C29.3880584,9.28422669 29.8647559,17.2007749 25.7421403,22.7792454 L31.4029793,28.4400843 C32.2180024,29.2551074 32.2248604,30.569663 31.4056282,31.3888951 C30.5920681,32.2024552 29.2715215,32.2009502 28.4568175,31.3862462 L22.8048272,25.7342559 Z M21.3193717,21.3628455 C25.213839,17.4683781 25.2042049,11.1445649 21.2978532,7.23821321 C17.3915016,3.33186156 11.0676883,3.32222743 7.17322097,7.21669477 C3.27875362,11.1111621 3.28838776,17.4349754 7.1947394,21.341327 C11.1010911,25.2476787 17.4249043,25.2573128 21.3193717,21.3628455 Z M8.34528717,12.453545 L19.7423242,12.453545 L19.7423242,15.7197782 L8.34528717,15.7197782 L8.34528717,12.453545 Z",
};

// $FlowFixMe
ICON_PATHS["horizontal_bar"] = {
  path: ICON_PATHS["bar"],
  attrs: {
    style: { transform: "rotate(90deg) scaleX(-1)" },
  },
};

// $FlowFixMe
ICON_PATHS["arrow_right"] = {
  path: ICON_PATHS["arrow_left"].path,
  attrs: {
    ...ICON_PATHS["arrow_left"].attrs,
    style: { transform: "rotate(-180deg)" },
  },
};

// $FlowFixMe
ICON_PATHS["join_right_outer"] = {
  path: ICON_PATHS["join_left_outer"],
  attrs: {
    style: { transform: "rotate(-180deg)" },
  },
};

// $FlowFixMe
ICON_PATHS["scalar"] = ICON_PATHS["number"];

export function parseViewBox(viewBox: string): Array<number> {
  // a viewBox is a string that takes the form 'min-x, min-y, width, height'
  // grab the values and return just width and height since we currently don't
  // tend to care about min-x or min-y

  // we cast to numbers so we can do math-y stuff with the width and height
  return viewBox
    .split(" ")
    .map(v => Number(v))
    .slice(2, 4);
}

export function loadIcon(name: string) {
  const def = ICON_PATHS[name];
  if (!def) {
    return null;
  }

  if (def.img) {
    return { ...def, attrs: { ...def.attrs, className: "Icon Icon-" + name } };
  }

  const icon = {
    attrs: {
      className: "Icon Icon-" + name,
      viewBox: "0 0 32 32",
      width: 16,
      height: 16,
      fill: "currentcolor",
      role: "img",
      "aria-label": name + " icon",
    },
    svg: undefined,
    path: undefined,
  };

  if (typeof def === "string") {
    icon.path = def;
  } else if (def != null) {
    const { svg, path, attrs } = def;
    for (const attr in attrs) {
      icon.attrs[attr] = attrs[attr];
    }

    // Note - @kdoh 10/13/2017
    // in the case of a custom viewBox, we need to set the width and height
    // of the icon def based on the view box since we're scaling all icons
    // down by half currently
    if (attrs && attrs.viewBox) {
      const [width, height] = parseViewBox(attrs.viewBox);
      icon.attrs.width = width / 2;
      icon.attrs.height = height / 2;
    }
    icon.path = path;
    icon.svg = svg;
  }

  return icon;
}
